/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.server.TickTaskBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.world.BlockChange;

public interface IPhaseState<C extends PhaseContext<C>> {
    public static final BiConsumer<CauseStackManager.StackFrame, ? extends PhaseContext<@NonNull ?>> DEFAULT_OWNER_NOTIFIER = (frame, ctx) -> {
        if (ctx.usedFrame == null) {
            ctx.usedFrame = new ArrayDeque<CauseStackManager.StackFrame>();
        }
        ctx.usedFrame.push((CauseStackManager.StackFrame)frame);
        if (ctx.creator != null) {
            frame.addContext(EventContextKeys.CREATOR, ctx.creator);
        }
        if (ctx.notifier != null) {
            frame.addContext(EventContextKeys.NOTIFIER, ctx.notifier);
        }
    };

    public C createPhaseContext(PhaseTracker var1);

    default public BiConsumer<CauseStackManager.StackFrame, C> getFrameModifier() {
        return DEFAULT_OWNER_NOTIFIER;
    }

    default public boolean isInteraction() {
        return false;
    }

    public void unwind(C var1);

    default public void postBlockTransactionApplication(C context, BlockChange blockChange, BlockTransactionReceipt receipt) {
    }

    default public boolean tracksCreatorsAndNotifiers() {
        return true;
    }

    default public boolean doesAllowEntitySpawns() {
        return true;
    }

    default public boolean doesBlockEventTracking(C context) {
        return true;
    }

    default public boolean allowsEntityCollisionEvents() {
        return false;
    }

    default public boolean ignoresBlockEvent() {
        return false;
    }

    default public boolean requiresPost() {
        return true;
    }

    default public void associateNeighborStateNotifier(C unwindingContext, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext, C currentPhaseData) {
    }

    default public void appendNotifierPreBlockTick(ServerWorld world, BlockPos pos, C context, LocationBasedTickContext<@NonNull ?> phaseContext) {
        Chunk chunk = world.func_175726_f(pos);
        LevelChunkBridge mixinChunk = (LevelChunkBridge)chunk;
        if (chunk != null && !chunk.func_76621_g()) {
            mixinChunk.bridge$getBlockCreatorUUID(pos).ifPresent(phaseContext::creator);
            mixinChunk.bridge$getBlockNotifierUUID(pos).ifPresent(phaseContext::notifier);
        }
    }

    default public void appendNotifierToBlockEvent(C context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
    }

    default public void capturePlayerUsingStackToBreakBlock(@Nullable ServerPlayerEntity playerIn, C context) {
    }

    default public boolean allowsEventListener() {
        return true;
    }

    default public ChangeBlock createTransaction(C phaseContext, SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        ChangeBlock changeBlock = ((PhaseContext)phaseContext).getTransactor().logBlockChange(originalBlockSnapshot, newState, flags);
        return changeBlock;
    }

    default public BlockChange associateBlockChangeWithSnapshot(C phaseContext, BlockState newState, BlockState currentState) {
        Block newBlock = newState.func_177230_c();
        Block currentBlock = currentState.func_177230_c();
        if (newBlock == Blocks.field_150350_a) {
            return BlockChange.BREAK;
        }
        if (newBlock != currentBlock && !TrackingUtil.forceModify(currentBlock, newBlock)) {
            return BlockChange.PLACE;
        }
        return BlockChange.MODIFY;
    }

    default public boolean shouldProvideModifiers(C phaseContext) {
        return true;
    }

    default public boolean isRestoring() {
        return false;
    }

    default public Supplier<SpawnType> getSpawnTypeForTransaction(C context, net.minecraft.entity.Entity entityToSpawn) {
        if (entityToSpawn instanceof ItemEntity) {
            return SpawnTypes.DROPPED_ITEM;
        }
        return SpawnTypes.PASSIVE;
    }

    default public SpawnEntityEvent createSpawnEvent(C context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<net.minecraft.entity.Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        return SpongeEventFactory.createSpawnEntityEvent(currentCause, collect.stream().map(t2 -> (Entity)t2.first()).collect(Collectors.toList()));
    }

    default public void populateLootContext(C phaseContext, LootContext.Builder lootBuilder) {
    }

    default public Operation getBlockOperation(C phaseContext, SpongeBlockSnapshot original, SpongeBlockSnapshot result) {
        return this.associateBlockChangeWithSnapshot(phaseContext, result.nativeState(), original.nativeState()).toOperation();
    }

    default public void foldContextForThread(C context, TickTaskBridge returnValue) {
    }

    default public void associateScheduledTickUpdate(C asContext, ServerWorld level, NextTickListEntry<?> entry) {
    }

    default public boolean isApplyingStreams() {
        return false;
    }

    default public Supplier<ResourceKey> attemptWorldKey(C context) {
        return () -> {
            throw new IllegalStateException("Unable to provide a ServerLevel");
        };
    }

    default public @Nullable ClickContainerEvent createContainerEvent(C context, Cause cause, ServerPlayerEntity serverPlayer, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return null;
    }

    default public boolean doesContainerCaptureEntitySpawn(C context, net.minecraft.entity.Entity entityIn) {
        return false;
    }
}

