/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.server.TickTaskBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickContext;
import org.spongepowered.common.world.BlockChange;

public interface PhaseStateProxy<C extends PhaseContext<C>> {
    public IPhaseState<C> getState();

    public C asContext();

    default public Consumer<CauseStackManager.StackFrame> getFrameModifier() {
        return frame -> this.getState().getFrameModifier().accept((CauseStackManager.StackFrame)frame, this.asContext());
    }

    default public boolean isInteraction() {
        return this.getState().isInteraction();
    }

    default public void postBlockTransactionApplication(BlockChange blockChange, BlockTransactionReceipt receipt) {
        this.getState().postBlockTransactionApplication(this.asContext(), blockChange, receipt);
    }

    default public boolean tracksCreatorsAndNotifiers() {
        return this.getState().tracksCreatorsAndNotifiers();
    }

    default public boolean doesAllowEntitySpawns() {
        return this.getState().doesAllowEntitySpawns();
    }

    default public boolean doesBlockEventTracking() {
        return this.getState().doesBlockEventTracking(this.asContext());
    }

    default public boolean allowsEntityCollisionEvents() {
        return this.getState().allowsEntityCollisionEvents();
    }

    default public boolean ignoresBlockEvent() {
        return this.getState().ignoresBlockEvent();
    }

    default public boolean requiresPost() {
        return this.getState().requiresPost();
    }

    default public void associateNeighborStateNotifier(@Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        this.getState().associateNeighborStateNotifier(this.asContext(), sourcePos, block, notifyPos, minecraftWorld, notifier);
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext) {
        this.getState().appendContextPreExplosion(explosionContext, this.asContext());
    }

    default public void appendNotifierPreBlockTick(ServerWorld world, BlockPos pos, LocationBasedTickContext<@NonNull ?> phaseContext) {
        this.getState().appendNotifierPreBlockTick(world, pos, this.asContext(), phaseContext);
    }

    default public void appendNotifierToBlockEvent(TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
        this.getState().appendNotifierToBlockEvent(this.asContext(), mixinWorldServer, pos, blockEvent);
    }

    default public void capturePlayerUsingStackToBreakBlock(@Nullable ServerPlayerEntity playerIn) {
        this.getState().capturePlayerUsingStackToBreakBlock(playerIn, this.asContext());
    }

    default public boolean allowsEventListener() {
        return this.getState().allowsEventListener();
    }

    default public ChangeBlock createTransaction(SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        return this.getState().createTransaction(this.asContext(), originalBlockSnapshot, newState, flags);
    }

    default public BlockChange associateBlockChangeWithSnapshot(BlockState newState, BlockState currentState) {
        return this.getState().associateBlockChangeWithSnapshot(this.asContext(), newState, currentState);
    }

    default public boolean shouldProvideModifiers() {
        return this.getState().shouldProvideModifiers(this.asContext());
    }

    default public boolean isRestoring() {
        return this.getState().isRestoring();
    }

    default public Supplier<SpawnType> getSpawnTypeForTransaction(Entity entityToSpawn) {
        return this.getState().getSpawnTypeForTransaction(this.asContext(), entityToSpawn);
    }

    default public SpawnEntityEvent createSpawnEvent(@Nullable GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        return this.getState().createSpawnEvent(this.asContext(), parent, collect, currentCause);
    }

    default public void populateLootContext(LootContext.Builder lootBuilder) {
        this.getState().populateLootContext(this.asContext(), lootBuilder);
    }

    default public Operation getBlockOperation(SpongeBlockSnapshot original, SpongeBlockSnapshot result) {
        return this.getState().getBlockOperation(this.asContext(), original, result);
    }

    default public void foldContextForThread(TickTaskBridge returnValue) {
        this.getState().foldContextForThread(this.asContext(), returnValue);
    }

    default public void associateScheduledTickUpdate(ServerWorld level, NextTickListEntry<?> entry) {
        this.getState().associateScheduledTickUpdate(this.asContext(), level, entry);
    }

    default public boolean isApplyingStreams() {
        return this.getState().isApplyingStreams();
    }

    default public Supplier<ResourceKey> attemptWorldKey() {
        return this.getState().attemptWorldKey(this.asContext());
    }

    default public @Nullable ClickContainerEvent createContainerEvent(Cause cause, ServerPlayerEntity playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<org.spongepowered.api.entity.Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        return this.getState().createContainerEvent(this.asContext(), cause, playerMP, openContainer, transaction, slotTransactions, capturedEntities, usedButton, slot);
    }

    default public boolean doesContainerCaptureEntitySpawn(Entity entityIn) {
        return this.getState().doesContainerCaptureEntitySpawn(this.asContext(), entityIn);
    }
}

