/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.inventory.ViewableInventoryBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.block.entity.BlockEntityBridge;
import org.spongepowered.common.bridge.world.level.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.bridge.world.level.chunk.TrackedLevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhasePrinter;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.FluidTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

public final class TrackingUtil {
    public static final Marker ENTITY_TICK = MarkerManager.getMarker("ENTITY TICK");
    public static final Marker TILE_ENTITY_TICK = MarkerManager.getMarker("TILE ENTITY TICK");
    public static final Marker PLAYER_TICK = MarkerManager.getMarker("PLAYER TICK");
    public static final Marker BLOCK_TICK = MarkerManager.getMarker("BLOCK TICK");
    public static final Marker FLUID_TICK = MarkerManager.getMarker("FLUID TICK");
    public static final Marker NEIGHBOR_UPDATE = MarkerManager.getMarker("NEIGHBOR UPDATE");
    public static final int BREAK_BLOCK_INDEX = BlockChange.BREAK.ordinal();
    public static final int PLACE_BLOCK_INDEX = BlockChange.PLACE.ordinal();
    public static final int DECAY_BLOCK_INDEX = BlockChange.DECAY.ordinal();
    public static final int CHANGE_BLOCK_INDEX = BlockChange.MODIFY.ordinal();
    private static final int MULTI_CHANGE_INDEX = BlockChange.values().length;
    static final Function<SpongeBlockSnapshot, Optional<Transaction<BlockSnapshot>>> TRANSACTION_CREATION = blockSnapshot -> blockSnapshot.getServerWorld().map(worldServer -> {
        BlockPos targetPos = blockSnapshot.getBlockPos();
        SpongeBlockSnapshot replacement = ((TrackedWorldBridge)worldServer).bridge$createSnapshot(targetPos, BlockChangeFlags.NONE);
        return new Transaction<SpongeBlockSnapshot>((SpongeBlockSnapshot)blockSnapshot, replacement);
    });
    public static final int WIDTH = 40;

    public static void tickEntity(Consumer<net.minecraft.entity.Entity> consumer, net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        if (!((TrackableBridge)entity).bridge$shouldTick()) {
            return;
        }
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext(PhaseTracker.SERVER).source(entity);
        try (EntityTickContext context = tickContext;){
            if (entity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)entity).tracker$getNotifierUUID().ifPresent(context::notifier);
                ((CreatorTrackedBridge)entity).tracker$getCreatorUUID().ifPresent(context::creator);
            }
            context.buildAndSwitch();
            consumer.accept(entity);
            if (ShouldFire.MOVE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalMoveEntityEvent(entity);
            }
            if (ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalRotateEntityEvent(entity);
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, tickContext);
        }
    }

    public static void tickRidingEntity(net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        if (!((TrackableBridge)entity).bridge$shouldTick()) {
            return;
        }
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext(PhaseTracker.SERVER).source(entity);
        try (EntityTickContext context = tickContext;){
            if (entity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)entity).tracker$getNotifierUUID().ifPresent(context::notifier);
                ((CreatorTrackedBridge)entity).tracker$getCreatorUUID().ifPresent(context::creator);
            }
            context.buildAndSwitch();
            entity.func_70098_U();
            if (ShouldFire.MOVE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalMoveEntityEvent(entity);
            }
            if (ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callNaturalRotateEntityEvent(entity);
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, tickContext);
        }
    }

    public static void tickTileEntity(TrackedWorldBridge mixinWorldServer, ITickableTileEntity tile) {
        Preconditions.checkArgument((boolean)(tile instanceof BlockEntity), (String)"ITickable %s is not a TileEntity!", (Object)tile);
        Preconditions.checkNotNull((Object)tile, (Object)"Cannot capture on a null ticking tile entity!");
        TileEntity tileEntity = (TileEntity)tile;
        BlockEntityBridge mixinTileEntity = (BlockEntityBridge)tile;
        BlockPos pos = tileEntity.func_174877_v();
        LevelChunkBridge chunk = ((ActiveChunkReferantBridge)tile).bridge$getActiveChunk();
        if (!((TrackableBridge)tileEntity).bridge$shouldTick()) {
            return;
        }
        if (chunk == null) {
            ((ActiveChunkReferantBridge)tile).bridge$setActiveChunk((TrackedLevelChunkBridge)tileEntity.func_145831_w().func_175726_f(tileEntity.func_174877_v()));
        }
        TileEntityTickContext context = TickPhase.Tick.TILE_ENTITY.createPhaseContext(PhaseTracker.SERVER).source(mixinTileEntity);
        try (TileEntityTickContext phaseContext = context;){
            Set<ServerPlayerEntity> players;
            if (tile instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)tile).tracker$getNotifierUUID().ifPresent(phaseContext::notifier);
                ((CreatorTrackedBridge)tile).tracker$getCreatorUUID().ifPresent(phaseContext::creator);
            }
            phaseContext.buildAndSwitch();
            tile.func_73660_a();
            if (tileEntity instanceof ViewableInventoryBridge && (players = ((ViewableInventoryBridge)tileEntity).viewableBridge$getViewers()).size() > 0) {
                players.forEach(player -> player.field_71070_bA.func_75142_b());
            }
        }
        catch (Exception e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, context);
        }
        if (tileEntity.func_145837_r()) {
            ((ActiveChunkReferantBridge)tileEntity).bridge$setActiveChunk(null);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void updateTickBlock(TrackedWorldBridge mixinWorld, net.minecraft.block.BlockState block, BlockPos pos, Random random) {
        net.minecraft.world.server.ServerWorld world = (net.minecraft.world.server.ServerWorld)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.bridge$createSnapshot(block, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(PhaseTracker.getCauseStackManager().currentCause(), snapshot);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)block).build();
        BlockTickContext phaseContext = TickPhase.Tick.BLOCK.createPhaseContext(PhaseTracker.SERVER).source(locatable);
        PhaseContext<@NonNull BlockTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_TICK, () -> "Wrapping Block Tick: " + block.toString());
            block.func_227033_a_(world, pos, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    public static void updateTickFluid(TrackedWorldBridge mixinWorld, FluidState fluidState, BlockPos pos) {
        net.minecraft.world.server.ServerWorld world = (net.minecraft.world.server.ServerWorld)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        net.minecraft.block.BlockState blockState = fluidState.func_206883_i();
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.bridge$createSnapshot(blockState, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(PhaseTracker.getCauseStackManager().currentCause(), snapshot);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)blockState).build();
        FluidTickContext phaseContext = TickPhase.Tick.FLUID.createPhaseContext(PhaseTracker.SERVER).source(locatable).fluid(fluidState);
        PhaseContext<@NonNull FluidTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (FluidTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(FLUID_TICK, () -> "Wrapping Fluid Tick: " + fluidState.toString());
            fluidState.func_206880_a((World)world, pos);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void randomTickBlock(TrackedWorldBridge mixinWorld, net.minecraft.block.BlockState state, BlockPos pos, Random random) {
        net.minecraft.world.server.ServerWorld world = (net.minecraft.world.server.ServerWorld)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.bridge$createSnapshot(state, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(PhaseTracker.getCauseStackManager().currentCause(), currentTickBlock);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)state).build();
        BlockTickContext phaseContext = TickPhase.Tick.RANDOM_BLOCK.createPhaseContext(PhaseTracker.SERVER).source(locatable);
        PhaseContext<@NonNull BlockTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(BLOCK_TICK, "Wrapping Random Block Tick: {}", (Object)state);
            state.func_227034_b_(world, pos, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void randomTickFluid(TrackedWorldBridge mixinWorld, FluidState state, BlockPos pos, Random random) {
        net.minecraft.world.server.ServerWorld world = (net.minecraft.world.server.ServerWorld)mixinWorld;
        ServerWorld apiWorld = (ServerWorld)world;
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.bridge$createSnapshot(state.func_206883_i(), pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(PhaseTracker.getCauseStackManager().currentCause(), currentTickBlock);
            SpongeCommon.post(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)state.func_206883_i()).build();
        FluidTickContext phaseContext = TickPhase.Tick.RANDOM_FLUID.createPhaseContext(PhaseTracker.SERVER).source(locatable).fluid(state);
        PhaseContext<@NonNull FluidTickContext> currentContext = PhaseTracker.getInstance().getPhaseContext();
        currentContext.appendNotifierPreBlockTick(world, pos, phaseContext);
        try (@NonNull FluidTickContext context = phaseContext;){
            context.buildAndSwitch();
            PhaseTracker.LOGGER.trace(FLUID_TICK, () -> "Wrapping Random Fluid Tick: " + state.toString());
            state.func_206891_b((World)world, pos, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            PhasePrinter.printExceptionFromPhase(PhaseTracker.getInstance().stack, e, phaseContext);
        }
    }

    public static boolean fireMinecraftBlockEvent(net.minecraft.world.server.ServerWorld worldIn, BlockEventData event, net.minecraft.block.BlockState currentState) {
        Locatable source;
        TrackableBlockEventDataBridge blockEvent = (TrackableBlockEventDataBridge)event;
        Locatable locatable = source = blockEvent.bridge$getTileEntity() != null ? blockEvent.bridge$getTileEntity() : blockEvent.bridge$getTickingLocatable();
        if (source == null) {
            return currentState.func_235728_a_((World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e());
        }
        BlockEventTickContext phaseContext = TickPhase.Tick.BLOCK_EVENT.createPhaseContext(PhaseTracker.SERVER);
        phaseContext.source(source);
        UUID user = ((TrackableBlockEventDataBridge)event).bridge$getSourceUserUUID();
        if (user != null) {
            phaseContext.creator = user;
            phaseContext.notifier = user;
        }
        boolean result = true;
        try (BlockEventTickContext o = phaseContext;){
            o.buildAndSwitch();
            phaseContext.setEventSucceeded(currentState.func_235728_a_((World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e()));
            result = phaseContext.wasNotCancelled();
        }
        return result;
    }

    static boolean forceModify(Block originalBlock, Block newBlock) {
        if (originalBlock instanceof RepeaterBlock && newBlock instanceof RepeaterBlock) {
            return true;
        }
        if (originalBlock instanceof RedstoneTorchBlock && newBlock instanceof RedstoneTorchBlock) {
            return true;
        }
        return originalBlock instanceof RedstoneLampBlock && newBlock instanceof RedstoneLampBlock;
    }

    private TrackingUtil() {
    }

    public static @Nullable UUID getNotifierOrOwnerFromBlock(net.minecraft.world.server.ServerWorld world, BlockPos blockPos) {
        LevelChunkBridge mixinChunk = (LevelChunkBridge)world.func_175726_f(blockPos);
        UUID notifier = mixinChunk.bridge$getBlockNotifierUUID(blockPos).orElse(null);
        if (notifier != null) {
            return notifier;
        }
        return mixinChunk.bridge$getBlockCreatorUUID(blockPos).orElse(null);
    }

    public static Supplier<IllegalStateException> throwWithContext(String s2, PhaseContext<?> phaseContext) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Exception trying to process over a phase!").centre().hr();
            printer.addWrapped(40, "%s : %s", "State", phaseContext.state);
            printer.addWrapped(40, "%s :", "PhaseContext");
            PhasePrinter.CONTEXT_PRINTER.accept(printer, phaseContext);
            printer.add("Stacktrace:");
            IllegalStateException exception = new IllegalStateException(s2 + " Please analyze the current phase context. ");
            printer.add(exception);
            printer.trace(System.err, SpongeCommon.logger(), Level.ERROR);
            return exception;
        };
    }

    public static boolean processBlockCaptures(PhaseContext<?> context) {
        TransactionalCaptureSupplier transactor = context.getTransactor();
        if (transactor.isEmpty()) {
            return false;
        }
        return transactor.processTransactions(context);
    }

    public static void associateTrackerToTarget(BlockChange blockChange, BlockTransactionReceipt receipt, UUID uuid) {
        BlockSnapshot finalSnapshot = receipt.finalBlock();
        SpongeBlockSnapshot spongeSnapshot = (SpongeBlockSnapshot)finalSnapshot;
        BlockPos pos = spongeSnapshot.getBlockPos();
        Block block = ((net.minecraft.block.BlockState)spongeSnapshot.state()).func_177230_c();
        spongeSnapshot.getServerWorld().map(world -> world.func_175726_f(pos)).map(chunk -> (LevelChunkBridge)chunk).ifPresent(spongeChunk -> {
            PlayerTracker.Type trackerType = blockChange == BlockChange.PLACE ? PlayerTracker.Type.CREATOR : PlayerTracker.Type.NOTIFIER;
            spongeChunk.bridge$addTrackedBlockPosition(block, pos, uuid, trackerType);
        });
    }

    public static void setCreatorReference(List<Entity> entities, ServerPlayerEntity player) {
        for (Entity currentEntity : entities) {
            if (currentEntity instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)((Object)currentEntity)).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, ((ServerPlayer)player).uniqueId());
                continue;
            }
            currentEntity.offer(Keys.CREATOR, player.func_110124_au());
        }
    }

    public static void addTileEntityToBuilder(TileEntity existing, SpongeBlockSnapshot.BuilderImpl builder) {
        CompoundNBT compound = new CompoundNBT();
        try {
            existing.func_189515_b(compound);
            builder.addUnsafeCompound(compound);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String phaseStateToString(String type, IPhaseState<?> state) {
        return TrackingUtil.phaseStateToString(type, null, state);
    }

    public static String phaseStateToString(String type, @Nullable String extra, IPhaseState<?> state) {
        String name = state.getClass().getSimpleName();
        name = name.replace("Phase", "");
        name = name.replace("State", "");
        name = name.replace(type, "");
        if (extra == null) {
            return type + "{" + name + "}";
        }
        if (name.isEmpty()) {
            return type + "{" + extra + "}";
        }
        return type + "{" + name + ":" + extra + "}";
    }

    public static SpongeBlockSnapshot createPooledSnapshot(net.minecraft.block.BlockState state, BlockPos pos, BlockChangeFlag updateFlag, int limit, @Nullable TileEntity blockEntity, Supplier<net.minecraft.world.server.ServerWorld> worldSupplier, Supplier<Optional<UUID>> creatorSupplier, Supplier<Optional<UUID>> notifierSupplier) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled();
        builder.reset();
        builder.blockState(state).world(worldSupplier.get()).position(VecHelper.toVector3i(pos));
        creatorSupplier.get().ifPresent(builder::creator);
        notifierSupplier.get().ifPresent(builder::notifier);
        if (blockEntity != null) {
            TrackingUtil.addTileEntityToBuilder(blockEntity, builder);
        }
        builder.flag(updateFlag);
        return builder.build();
    }
}

