/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.StatefulTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.util.PrettyPrinter;

public abstract class GameTransaction<E extends Event & Cancellable>
implements TransactionFlow,
StatefulTransaction {
    private final TransactionType<? extends E> transactionType;
    protected boolean cancelled = false;
    @Nullable LinkedList<ResultingTransactionBySideEffect> sideEffects;
    @Nullable GameTransaction<@NonNull ?> previous;
    @Nullable GameTransaction<@NonNull ?> next;
    private boolean recorded = false;

    protected GameTransaction(TransactionType<? extends E> transactionType) {
        this.transactionType = transactionType;
    }

    public String toString() {
        return new StringJoiner(", ", GameTransaction.class.getSimpleName() + "[", "]").toString();
    }

    public final TransactionType<? extends E> getTransactionType() {
        return this.transactionType;
    }

    final Deque<ResultingTransactionBySideEffect> getEffects() {
        if (this.sideEffects == null) {
            this.sideEffects = new LinkedList();
        }
        return this.sideEffects;
    }

    public final void addLast(ResultingTransactionBySideEffect effect) {
        if (this.sideEffects == null) {
            this.sideEffects = new LinkedList();
        }
        this.sideEffects.addLast(effect);
    }

    public final boolean hasChildTransactions() {
        return this.sideEffects != null && this.sideEffects.stream().anyMatch(effect -> effect.head != null);
    }

    public final boolean hasAnyPrimaryChildrenTransactions() {
        if (this.sideEffects == null) {
            return false;
        }
        for (ResultingTransactionBySideEffect sideEffect : this.sideEffects) {
            @Nullable GameTransaction<@NonNull ?> transaction = sideEffect.head;
            while (transaction != null) {
                if (transaction.transactionType.isPrimary() || transaction.hasChildTransactions()) {
                    return true;
                }
                transaction = transaction.next;
            }
        }
        return false;
    }

    public abstract Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> var1);

    public abstract void addToPrinter(PrettyPrinter var1);

    public boolean isUnbatchable() {
        return false;
    }

    public abstract Optional<E> generateEvent(PhaseContext<@NonNull ?> var1, @Nullable GameTransaction<@NonNull ?> var2, ImmutableList<GameTransaction<E>> var3, Cause var4);

    public abstract void restore(PhaseContext<@NonNull ?> var1, E var2);

    public final void markCancelled() {
        this.cancelled = true;
        this.childIterator().forEachRemaining(GameTransaction::markCancelled);
    }

    public abstract boolean markCancelledTransactions(E var1, ImmutableList<? extends GameTransaction<E>> var2);

    public void postProcessEvent(PhaseContext<@NonNull ?> context, E event) {
    }

    public void markEventAsCancelledIfNecessary(E event) {
        if (this.cancelled) {
            ((Cancellable)event).setCancelled(true);
        }
    }

    public Optional<ResourceKey> worldKey() {
        return Optional.empty();
    }

    protected boolean shouldBuildEventAndRestartBatch(GameTransaction<@NonNull ?> pointer, PhaseContext<@NonNull ?> context) {
        return this.getTransactionType() != pointer.getTransactionType();
    }

    final void append(GameTransaction<@NonNull ?> child) {
        this.next = child;
        child.previous = this;
    }

    final Iterator<GameTransaction<@NonNull ?>> childIterator() {
        return this.sideEffects != null ? new ChildIterator(this.sideEffects.iterator()) : Collections.emptyIterator();
    }

    final Iterator<GameTransaction<@NonNull ?>> reverseChildIterator() {
        return this.sideEffects != null ? new ReverseChildIterator(this.sideEffects.descendingIterator()) : Collections.emptyIterator();
    }

    @Override
    public final boolean recorded() {
        return this.recorded;
    }

    public final GameTransaction<E> recordState() {
        this.captureState();
        this.recorded = true;
        return this;
    }

    protected void captureState() {
    }

    private static class ReverseChildIterator
    implements Iterator<GameTransaction<?>> {
        private final Iterator<ResultingTransactionBySideEffect> effectIterator;
        private @Nullable GameTransaction<@NonNull ?> cachedPrevious;
        private @MonotonicNonNull GameTransaction<@NonNull ?> pointer;
        private boolean hasNoRemainingElements = false;

        ReverseChildIterator(Iterator<ResultingTransactionBySideEffect> iterator) {
            this.effectIterator = iterator;
            while (this.effectIterator.hasNext()) {
                ResultingTransactionBySideEffect next = this.effectIterator.next();
                if (next.tail == null) continue;
                this.pointer = next.tail;
                this.cachedPrevious = next.tail;
                break;
            }
            if (this.pointer == null) {
                this.hasNoRemainingElements = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cachedPrevious != null) {
                return true;
            }
            if (this.hasNoRemainingElements) {
                return false;
            }
            if (this.pointer.previous != null) {
                this.cachedPrevious = this.pointer.previous;
                return true;
            }
            while (this.effectIterator.hasNext()) {
                ResultingTransactionBySideEffect next = this.effectIterator.next();
                if (next.tail == null) continue;
                this.cachedPrevious = next.tail;
                return true;
            }
            this.hasNoRemainingElements = true;
            return false;
        }

        @Override
        public GameTransaction<@NonNull ?> next() {
            if (this.cachedPrevious != null) {
                GameTransaction<@NonNull ?> next = this.cachedPrevious;
                this.cachedPrevious = null;
                this.pointer = next;
                return next;
            }
            if (this.hasNoRemainingElements) {
                throw new NoSuchElementException("No next GameTransaction to iterate to");
            }
            if (this.hasNext()) {
                return this.next();
            }
            throw new NoSuchElementException("No next GameTransaction to iterate to");
        }
    }

    private static class ChildIterator
    implements Iterator<GameTransaction<?>> {
        private final Iterator<ResultingTransactionBySideEffect> effectIterator;
        private @Nullable GameTransaction<@NonNull ?> cachedNext;
        private @MonotonicNonNull GameTransaction<@NonNull ?> pointer;
        private boolean hasNoRemainingElements = false;

        ChildIterator(Iterator<ResultingTransactionBySideEffect> iterator) {
            this.effectIterator = iterator;
            while (this.effectIterator.hasNext()) {
                ResultingTransactionBySideEffect next = this.effectIterator.next();
                if (next.head == null) continue;
                this.cachedNext = next.head;
                this.pointer = next.head;
                break;
            }
            if (this.pointer == null) {
                this.hasNoRemainingElements = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.cachedNext != null) {
                return true;
            }
            if (this.hasNoRemainingElements) {
                return false;
            }
            if (this.pointer.next != null) {
                this.cachedNext = this.pointer.next;
                return true;
            }
            while (this.effectIterator.hasNext()) {
                ResultingTransactionBySideEffect next = this.effectIterator.next();
                if (next.head == null) continue;
                this.cachedNext = next.head;
                return true;
            }
            this.hasNoRemainingElements = true;
            return false;
        }

        @Override
        public GameTransaction<@NonNull ?> next() {
            if (this.cachedNext != null) {
                GameTransaction<@NonNull ?> next = this.cachedNext;
                this.pointer = next;
                this.cachedNext = null;
                return next;
            }
            if (this.hasNoRemainingElements) {
                throw new NoSuchElementException("No next GameTransaction to iterate to");
            }
            if (this.hasNext()) {
                return this.next();
            }
            throw new NoSuchElementException("No next GameTransaction to iterate to");
        }
    }
}

