/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.inventory.InventoryMenuAccessor;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.UnwindingPhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.StatefulTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.AddBlockEventTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.AddTileEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.block.NeighborNotification;
import org.spongepowered.common.event.tracking.context.transaction.block.PrepareBlockDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.RemoveBlockEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ReplaceBlockEntity;
import org.spongepowered.common.event.tracking.context.transaction.block.ScheduleUpdateTransaction;
import org.spongepowered.common.event.tracking.context.transaction.effect.EntityPerformingDropsEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.InventoryEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.PrepareBlockDrops;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ClickCreativeMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ClickMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CloseMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingPreviewTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.DropFromPlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.OpenMenuTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlaceRecipeTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SelectTradeTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetCarriedItemTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetPlayerContainerTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ShiftCraftingResultTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.EntityPerformingDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

interface TransactionSink {
    @Deprecated
    public void logTransaction(StatefulTransaction var1);

    public EffectTransactor pushEffect(ResultingTransactionBySideEffect var1);

    default public ChangeBlock logBlockChange(SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        ChangeBlock changeBlock = new ChangeBlock(originalBlockSnapshot, newState, (SpongeBlockChangeFlag)flags);
        this.logTransaction(changeBlock);
        return changeBlock;
    }

    default public void logBlockEvent(BlockState state, TrackedWorldBridge serverWorld, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)serverWorld);
        Supplier<ServerWorld> worldSupplier = () -> Objects.requireNonNull((ServerWorld)worldRef.get(), "ServerWorld dereferenced");
        @Nullable TileEntity tileEntity = ((ServerWorld)serverWorld).func_175625_s(pos);
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        AddBlockEventTransaction transaction = new AddBlockEventTransaction(original, blockEvent);
        this.logTransaction(transaction);
    }

    default public EffectTransactor logBlockDrops(World serverWorld, BlockPos pos, BlockState state, @Nullable TileEntity tileEntity) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)serverWorld);
        Supplier<ServerWorld> worldSupplier = () -> Objects.requireNonNull((ServerWorld)worldRef.get(), "ServerWorld dereferenced");
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        PrepareBlockDropsTransaction transaction = new PrepareBlockDropsTransaction(pos, state, original);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(PrepareBlockDrops.getInstance()));
    }

    default public void logScheduledUpdate(ServerWorld serverWorld, NextTickListEntry<?> data) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>(serverWorld);
        Supplier<ServerWorld> worldSupplier = () -> Objects.requireNonNull((ServerWorld)worldRef.get(), "ServerWorld dereferenced");
        @Nullable TileEntity tileEntity = serverWorld.func_175625_s(data.field_180282_a);
        BlockState existing = serverWorld.func_180495_p(data.field_180282_a);
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(existing, data.field_180282_a, BlockChangeFlags.NONE, 512, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        ScheduleUpdateTransaction transaction = new ScheduleUpdateTransaction(original, data);
        this.logTransaction(transaction);
    }

    default public void logNeighborNotification(Supplier<ServerWorld> serverWorldSupplier, BlockPos immutableFrom, Block blockIn, BlockPos immutableTarget, BlockState targetBlockState, @Nullable TileEntity existingTile) {
        NeighborNotification notificationTransaction = new NeighborNotification(serverWorldSupplier, targetBlockState, immutableTarget, blockIn, immutableFrom, existingTile);
        this.logTransaction(notificationTransaction);
    }

    default public void logEntitySpawn(PhaseContext<@NonNull ?> current, TrackedWorldBridge serverWorld, Entity entityIn) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)serverWorld);
        Supplier<ServerWorld> worldSupplier = () -> Objects.requireNonNull((ServerWorld)worldRef.get(), "ServerWorld dereferenced");
        Supplier<SpawnType> contextualType = current.getSpawnTypeForTransaction(entityIn);
        SpawnEntityTransaction transaction = new SpawnEntityTransaction(worldSupplier, entityIn, contextualType);
        this.logTransaction(transaction);
    }

    default public boolean logTileReplacement(BlockPos pos, @Nullable TileEntity existing, @Nullable TileEntity proposed, Supplier<ServerWorld> worldSupplier) {
        if (proposed == null) {
            return false;
        }
        this.logTransaction(new ReplaceBlockEntity(pos, existing, proposed, worldSupplier));
        return true;
    }

    default public boolean logTileAddition(TileEntity tileEntity, Supplier<ServerWorld> worldSupplier, Chunk chunk) {
        this.logTransaction(this.createTileAdditionTransaction(tileEntity, worldSupplier, chunk));
        return true;
    }

    default public AddTileEntity createTileAdditionTransaction(TileEntity tileentity, Supplier<ServerWorld> worldSupplier, Chunk chunk) {
        Supplier<Chunk> weaklyReferencedSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier(chunk, "LevelChunk");
        return new AddTileEntity(tileentity, worldSupplier, weaklyReferencedSupplier);
    }

    default public boolean logTileRemoval(@Nullable TileEntity tileentity, Supplier<ServerWorld> worldSupplier) {
        if (tileentity == null) {
            return false;
        }
        this.logTransaction(new RemoveBlockEntity(tileentity, worldSupplier));
        return true;
    }

    default public @Nullable EffectTransactor ensureEntityDropTransactionEffect(Entity entity) {
        EntityPerformingDropsTransaction transaction = new EntityPerformingDropsTransaction(entity);
        this.logTransaction(transaction);
        if (transaction.recorded()) {
            return this.pushEffect(new ResultingTransactionBySideEffect(EntityPerformingDropsEffect.getInstance()));
        }
        return null;
    }

    default public void logSlotTransaction(PhaseContext<@NonNull ?> phaseContext, SlotTransaction newTransaction, Container abstractContainerMenu) {
        if (abstractContainerMenu instanceof PlayerContainer) {
            if (phaseContext instanceof CommandPhaseContext) {
                this.logPlayerInventoryChange(((InventoryMenuAccessor)abstractContainerMenu).accessor$owner(), PlayerInventoryTransaction.EventCreator.STANDARD);
            }
            if (phaseContext instanceof UnwindingPhaseContext) {
                return;
            }
            if (phaseContext instanceof EntityTickContext) {
                SpongeCommon.logger().warn("Ignoring slot transaction on InventoryMenu during {}. {}\nNo Event will be fired for this", (Object)phaseContext.getClass().getSimpleName(), (Object)newTransaction);
                return;
            }
        }
        ContainerSlotTransaction transaction = new ContainerSlotTransaction(abstractContainerMenu, newTransaction);
        this.logTransaction(transaction);
    }

    default public void logPlayerCarriedItem(PlayerEntity player, int newSlot) {
        SetCarriedItemTransaction transaction = new SetCarriedItemTransaction(player, newSlot);
        this.logTransaction(transaction);
    }

    default public void logPlayerInventoryChange(PlayerEntity player, PlayerInventoryTransaction.EventCreator eventCreator) {
        PlayerInventoryTransaction transaction = new PlayerInventoryTransaction(player, eventCreator);
        this.logTransaction(transaction);
    }

    default public EffectTransactor logClickContainer(Container menu, int slotNum, int buttonNum, ClickType clickType, PlayerEntity player) {
        Slot slot = null;
        if (buttonNum >= 0) {
            slot = ((InventoryAdapter)menu).inventoryAdapter$getSlot(slotNum).orElse(null);
        }
        ClickMenuTransaction transaction = new ClickMenuTransaction(player, menu, slotNum, buttonNum, clickType, slot, ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o()));
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logPlayerInventoryChangeWithEffect(PlayerEntity player, PlayerInventoryTransaction.EventCreator eventCreator) {
        PlayerInventoryTransaction transaction = new PlayerInventoryTransaction(player, eventCreator);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logCreativeClickContainer(int slotNum, ItemStackSnapshot creativeStack, PlayerEntity player) {
        ClickCreativeMenuTransaction transaction = new ClickCreativeMenuTransaction(player, slotNum, creativeStack);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logDropFromPlayerInventory(ServerPlayerEntity player, boolean dropAll) {
        DropFromPlayerInventoryTransaction transaction = new DropFromPlayerInventoryTransaction(player, dropAll);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logOpenInventory(PlayerEntity player) {
        OpenMenuTransaction transaction = new OpenMenuTransaction(player);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logCloseInventory(PlayerEntity player, boolean clientSource) {
        CloseMenuTransaction transaction = new CloseMenuTransaction(player, clientSource);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public EffectTransactor logPlaceRecipe(boolean shift, IRecipe<?> recipe, ServerPlayerEntity player, CraftingInventory craftInv) {
        PlaceRecipeTransaction transaction = new PlaceRecipeTransaction(player, shift, recipe, craftInv);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(InventoryEffect.getInstance()));
    }

    default public void logSelectTrade(ServerPlayerEntity player, int item) {
        SelectTradeTransaction transaction = new SelectTradeTransaction(player, item);
        this.logTransaction(transaction);
    }

    default public void logShiftCraftingResult(net.minecraft.inventory.container.Slot slot, ItemStack result) {
        ShiftCraftingResultTransaction transaction = new ShiftCraftingResultTransaction(slot, result);
        this.logTransaction(transaction);
    }

    default public void logContainerSet(PlayerEntity player) {
        SetPlayerContainerTransaction transaction = new SetPlayerContainerTransaction(player);
        this.logTransaction(transaction);
    }

    default public void logCraftingPreview(ServerPlayerEntity player, CraftingInventory craftingInventory, net.minecraft.inventory.CraftingInventory craftSlots) {
        CraftingPreviewTransaction transaction = new CraftingPreviewTransaction(player, craftingInventory, craftSlots);
        this.logTransaction(transaction);
    }

    default public void logCrafting(PlayerEntity player, @Nullable ItemStack craftedStack, CraftingInventory craftInv, @Nullable CraftingRecipe lastRecipe) {
        CraftingTransaction transaction = new CraftingTransaction(player, craftedStack, craftInv, lastRecipe);
        this.logTransaction(transaction);
    }
}

