/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.transaction.NotificationTicket;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeNotificationTicket;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

public final class NeighborNotification
extends WorldBasedTransaction<NotifyNeighborBlockEvent> {
    final net.minecraft.block.BlockState original;
    final BlockPos notifyPos;
    final Block sourceBlock;
    final BlockPos sourcePos;
    final BlockPos affectedPosition;
    final net.minecraft.block.BlockState originalState;
    private final Supplier<net.minecraft.world.server.ServerWorld> serverWorld;
    private Supplier<LocatableBlock> locatableBlock;
    private Supplier<SpongeBlockSnapshot> targetSnapshot;
    private Supplier<NotificationTicket> ticketSupplier;

    public NeighborNotification(Supplier<net.minecraft.world.server.ServerWorld> serverWorldSupplier, net.minecraft.block.BlockState notifyState, BlockPos notifyPos, Block sourceBlock, BlockPos sourcePos, @Nullable TileEntity existingTile) {
        super(TransactionTypes.NEIGHBOR_NOTIFICATION.get(), ((ServerWorld)serverWorldSupplier.get()).key());
        this.affectedPosition = sourcePos;
        this.originalState = notifyState;
        this.serverWorld = serverWorldSupplier;
        this.notifyPos = notifyPos;
        this.sourceBlock = sourceBlock;
        this.sourcePos = sourcePos;
        this.original = serverWorldSupplier.get().func_180495_p(sourcePos);
        this.locatableBlock = () -> {
            LocatableBlock locatableBlock = new SpongeLocatableBlockBuilder().world(this.serverWorld).position(this.sourcePos.func_177958_n(), this.sourcePos.func_177956_o(), this.sourcePos.func_177952_p()).state((BlockState)this.original).build();
            this.locatableBlock = () -> locatableBlock;
            return locatableBlock;
        };
        this.targetSnapshot = () -> {
            SpongeBlockSnapshot.BuilderImpl pooled = SpongeBlockSnapshot.BuilderImpl.pooled();
            pooled.world(this.serverWorld.get()).position(new Vector3i(notifyPos.func_177958_n(), notifyPos.func_177956_o(), notifyPos.func_177952_p())).blockState(notifyState);
            if (existingTile != null) {
                pooled.tileEntity(existingTile);
            }
            SpongeBlockSnapshot snapshot = pooled.build();
            this.targetSnapshot = () -> snapshot;
            return snapshot;
        };
        this.ticketSupplier = () -> {
            LocatableBlock notifier = this.locatableBlock.get();
            SpongeBlockSnapshot target = this.targetSnapshot.get();
            SpongeNotificationTicket ticket = new SpongeNotificationTicket(notifier, target);
            this.ticketSupplier = () -> ticket;
            return ticket;
        };
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", NeighborNotification.class.getSimpleName() + "[", "]").add("notifyState=" + this.originalState).add("notifyPos=" + this.notifyPos).add("sourceBlock=" + this.sourceBlock).add("sourcePos=" + this.sourcePos).add("actualSourceState=" + this.originalState).toString();
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> {
            if (parent instanceof ChangeBlock) {
                frame.pushCause(((ChangeBlock)parent).original);
            }
            frame.pushCause(this.ticketSupplier.get());
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("NeighborNotification").add(" %s : %s, %s", "Source Pos", this.sourceBlock, this.sourcePos).add(" %s : %s, %s", "Notification", this.originalState, this.notifyPos);
    }

    @Override
    public Optional<NotifyNeighborBlockEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<NotifyNeighborBlockEvent>> transactions, Cause currentCause) {
        ImmutableList tickets = (ImmutableList)transactions.stream().map(transaction -> ((NeighborNotification)transaction).ticketSupplier.get()).collect(ImmutableList.toImmutableList());
        return Optional.of(SpongeEventFactory.createNotifyNeighborBlockEvent(currentCause, (List<NotificationTicket>)tickets));
    }

    @Override
    public void restore(PhaseContext<?> context, NotifyNeighborBlockEvent event) {
    }

    @Override
    public boolean markCancelledTransactions(NotifyNeighborBlockEvent event, ImmutableList<? extends GameTransaction<NotifyNeighborBlockEvent>> blockTransactions) {
        boolean cancelledAny = false;
        for (NotificationTicket transaction : event.tickets()) {
            if (transaction.valid()) continue;
            cancelledAny = true;
            for (GameTransaction gameTransaction : blockTransactions) {
                NeighborNotification blockTransaction = (NeighborNotification)gameTransaction;
                Vector3i position = transaction.targetPosition();
                BlockPos affectedPosition = blockTransaction.affectedPosition;
                if (position.x() != affectedPosition.func_177958_n() || position.y() != affectedPosition.func_177956_o() || position.z() != affectedPosition.func_177952_p()) continue;
                gameTransaction.markCancelled();
            }
        }
        return cancelledAny;
    }

    @Override
    public void markEventAsCancelledIfNecessary(NotifyNeighborBlockEvent event) {
        super.markEventAsCancelledIfNecessary(event);
        event.tickets().forEach(NotificationTicket::invalidate);
    }
}

