/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;

public final class PrepareBlockDropsTransaction
extends BlockEventBasedTransaction {
    private final SpongeBlockSnapshot originalState;

    public PrepareBlockDropsTransaction(BlockPos affectedPosition, BlockState originalState, SpongeBlockSnapshot original) {
        super(affectedPosition, originalState, original.world());
        this.originalState = original;
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return null;
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.originalState;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> frame.pushCause(this.originalState));
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public void restore(PhaseContext<?> context, ChangeBlockEvent.All event) {
        this.originalState.restore(true, BlockChangeFlagManager.fromNativeInt(314));
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", PrepareBlockDropsTransaction.class.getSimpleName() + "[", "]").add("affectedPosition=" + this.affectedPosition).add("originalState=" + this.originalState).add("worldKey=" + this.worldKey).add("cancelled=" + this.cancelled).add("originalState=" + this.originalState).toString();
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.absorbBlockDropsPreparation(ctx, this));
    }
}

