/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;

public final class ReplaceBlockEntity
extends BlockEventBasedTransaction {
    final TileEntity added;
    final @Nullable TileEntity removed;
    private final Supplier<net.minecraft.world.server.ServerWorld> worldSupplier;
    @MonotonicNonNull SpongeBlockSnapshot removedSnapshot;

    public ReplaceBlockEntity(BlockPos pos, @Nullable TileEntity existing, TileEntity proposed, Supplier<net.minecraft.world.server.ServerWorld> worldSupplier) {
        super(pos, worldSupplier.get().func_180495_p(pos), ((ServerWorld)worldSupplier.get()).key());
        this.added = proposed;
        this.removed = existing;
        this.worldSupplier = worldSupplier;
    }

    @Override
    protected void captureState() {
        super.captureState();
        BlockState currentState = this.worldSupplier.get().func_180495_p(this.affectedPosition);
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, this.affectedPosition, BlockChangeFlags.NONE, 512, this.removed, this.worldSupplier, Optional::empty, Optional::empty);
        snapshot.blockChange = BlockChange.MODIFY;
        this.removedSnapshot = snapshot;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptTileReplacement(this.removed, this.added));
    }

    @Override
    public boolean acceptTileAddition(TileEntity tileEntity) {
        if (this.added == tileEntity) {
            return true;
        }
        return super.acceptTileAddition(tileEntity);
    }

    @Override
    public void restore(PhaseContext<?> context, ChangeBlockEvent.All event) {
        this.removedSnapshot.restore(true, BlockChangeFlags.NONE);
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("ReplaceTileEntity").add(" %s : %s", "Position", this.affectedPosition).add(" %s : %s", "Added", this.added).add(" %s : %s", "Removed", this.removed == null ? "null" : this.removed);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return SpongeBlockSnapshot.BuilderImpl.pooled().from(this.removedSnapshot).tileEntity(this.added).build();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.removedSnapshot;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", ReplaceBlockEntity.class.getSimpleName() + "[", "]").add("affectedPosition=" + this.affectedPosition).add("originalState=" + this.originalState).add("worldKey=" + this.worldKey).add("cancelled=" + this.cancelled).add("added=" + this.added).add("removed=" + this.removed).toString();
    }
}

