/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SCloseWindowPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.util.text.ITextComponent;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.MenuBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.PrettyPrinter;

public class CloseMenuTransaction
extends MenuBasedTransaction<InteractContainerEvent> {
    private final ServerPlayerEntity player;
    private final ItemStackSnapshot cursor;
    private boolean clientSource;
    private @MonotonicNonNull List<SlotTransaction> slotTransactions;

    public CloseMenuTransaction(PlayerEntity player, boolean clientSource) {
        super(TransactionTypes.INTERACT_CONTAINER_EVENT.get(), player.field_71070_bA);
        this.player = (ServerPlayerEntity)player;
        this.cursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        this.clientSource = clientSource;
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public Optional<InteractContainerEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<InteractContainerEvent>> gameTransactions, Cause currentCause) {
        ItemStackSnapshot resultingCursor = ItemStackUtil.snapshotOf(this.player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(this.cursor, resultingCursor);
        InteractContainerEvent.Close event = SpongeEventFactory.createInteractContainerEventClose(currentCause, (Container)this.menu, cursorTransaction, (Container)this.menu, this.slotTransactions == null ? Collections.emptyList() : this.slotTransactions);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        if (this.clientSource) {
            this.reopen(this.player, this.menu);
        }
        PacketPhaseUtil.handleCursorRestore((PlayerEntity)this.player, event.cursorTransaction());
        if (event instanceof ChangeInventoryEvent) {
            PacketPhaseUtil.handleSlotRestore((PlayerEntity)this.player, this.menu, ((ChangeInventoryEvent)((Object)event)).transactions(), event.isCancelled());
        }
        this.player.field_71069_bz.func_75142_b();
    }

    @Override
    public boolean absorbSlotTransaction(ContainerSlotTransaction slotTransaction) {
        if (this.menu != slotTransaction.menu) {
            return this.player.field_71069_bz == slotTransaction.menu;
        }
        if (this.slotTransactions == null) {
            this.slotTransactions = new ArrayList<SlotTransaction>();
        }
        this.slotTransactions.add(slotTransaction.transaction);
        return true;
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        if (!this.clientSource) {
            this.player.field_71135_a.func_147359_a((IPacket)new SCloseWindowPacket(this.player.field_71070_bA.field_75152_c));
        }
        this.player.field_71070_bA = this.player.field_71069_bz;
        PacketPhaseUtil.handleCursorRestore((PlayerEntity)this.player, event.cursorTransaction());
        if (event instanceof ChangeInventoryEvent) {
            PacketPhaseUtil.handleSlotRestore((PlayerEntity)this.player, this.menu, ((ChangeInventoryEvent)((Object)event)).transactions(), event.isCancelled());
        }
        this.player.field_71069_bz.func_75142_b();
    }

    @Override
    public boolean markCancelledTransactions(InteractContainerEvent event, ImmutableList<? extends GameTransaction<InteractContainerEvent>> gameTransactions) {
        if (event.isCancelled()) {
            event.cursorTransaction().invalidate();
            return true;
        }
        return !event.cursorTransaction().isValid();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    private void reopen(ServerPlayerEntity player, net.minecraft.inventory.container.Container container) {
        if (container.func_75139_a(0) == null) {
            return;
        }
        if (!(container instanceof PlayerContainer)) {
            player.field_71070_bA = container;
            Slot slot = container.func_75139_a(0);
            IInventory slotInventory = slot.field_75224_c;
            ITextComponent title = slotInventory instanceof INamedContainerProvider ? ((INamedContainerProvider)slotInventory).func_145748_c_() : null;
            slotInventory.func_174889_b((PlayerEntity)player);
            player.field_71135_a.func_147359_a((IPacket)new SOpenWindowPacket(container.field_75152_c, container.func_216957_a(), title));
            player.func_71120_a(container);
        }
    }
}

