/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.crafting.CraftingOutput;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.inventory.container.TrackedContainerBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingPreviewTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.CraftingTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.MenuBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ShiftCraftingResultTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.PrettyPrinter;

abstract class ContainerBasedTransaction
extends MenuBasedTransaction<ClickContainerEvent> {
    private static Set<Class<?>> containersFailedCapture = new ReferenceOpenHashSet();
    @MonotonicNonNull List<net.minecraft.entity.Entity> entities;
    protected @MonotonicNonNull List<SlotTransaction> acceptedTransactions;
    private @MonotonicNonNull CraftingInventory craftingInventory;
    private @MonotonicNonNull net.minecraft.inventory.CraftingInventory craftingContainer;
    private @Nullable ItemStack craftedStack;
    private @Nullable CraftingRecipe onTakeRecipe;
    protected boolean used = false;
    @Nullable ItemStack shiftCraftingResult;

    protected ContainerBasedTransaction(net.minecraft.inventory.container.Container menu) {
        super(TransactionTypes.CLICK_CONTAINER_EVENT.get(), menu);
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> frame.pushCause(this.menu));
    }

    @Override
    public Optional<ClickContainerEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<ClickContainerEvent>> gameTransactions, Cause currentCause) {
        ImmutableList containerBasedTransactions = (ImmutableList)gameTransactions.stream().filter(tx -> tx instanceof ContainerBasedTransaction).map(tx -> (ContainerBasedTransaction)tx).filter(tx -> !tx.used).collect(ImmutableList.toImmutableList());
        if (containerBasedTransactions.stream().map(c -> c.isContainerEventAllowed(context)).filter(b -> b == false).findAny().orElse(false).booleanValue()) {
            SpongeCommon.logger().warn("No event will be fired for existing ContainerBasedTransactions: {}", (Object)containerBasedTransactions.size());
            return Optional.empty();
        }
        if (!((TrackedContainerBridge)this.menu).bridge$capturePossible()) {
            // empty if block
        }
        List entities = containerBasedTransactions.stream().map(ContainerBasedTransaction::getEntitiesSpawned).flatMap(Collection::stream).collect(Collectors.toList());
        List<SlotTransaction> slotTransactions = containerBasedTransactions.stream().map(ContainerBasedTransaction::getSlotTransactions).flatMap(Collection::stream).collect(Collectors.toList());
        if (this.craftingInventory != null) {
            Object slot = this.craftingInventory.result();
            @Nullable SlotTransaction preview = this.findPreviewTransaction(this.craftingInventory.result(), slotTransactions);
            ItemStackSnapshot previewItem = ItemStackUtil.snapshotOf(this.craftingInventory.peek());
            if (preview != null) {
                slot = preview.slot();
                if (!((ItemStackSnapshot)preview.defaultReplacement()).equals(previewItem)) {
                    slotTransactions.remove(preview);
                    slotTransactions.add(new SlotTransaction((Slot)slot, (ItemStackSnapshot)preview.original(), previewItem));
                }
            } else if (!previewItem.isEmpty()) {
                slotTransactions.add(new SlotTransaction((Slot)slot, previewItem, previewItem));
            }
        }
        for (ContainerBasedTransaction transaction : containerBasedTransactions) {
            transaction.used = true;
        }
        Optional<ClickContainerEvent> event = containerBasedTransactions.stream().map(t2 -> t2.createInventoryEvent(slotTransactions, entities, context, currentCause)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (!event.isPresent() && !slotTransactions.isEmpty()) {
            SpongeCommon.logger().warn("Logged slot transactions without event! {} {}", (Object)gameTransactions.size(), (Object)this.menu.getClass().getName(), (Object)new Exception(""));
            for (SlotTransaction slotTransaction : slotTransactions) {
                SpongeCommon.logger().warn(slotTransaction);
            }
        }
        return event;
    }

    List<Entity> getEntitiesSpawned() {
        return this.entities == null ? Collections.emptyList() : this.entities;
    }

    boolean isContainerEventAllowed(PhaseContext<@NonNull ?> context) {
        return true;
    }

    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause currentCause) {
        return Optional.empty();
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
    }

    @Override
    public boolean markCancelledTransactions(ClickContainerEvent event, ImmutableList<? extends GameTransaction<ClickContainerEvent>> gameTransactions) {
        if (event.isCancelled()) {
            event.transactions().forEach(Transaction::invalidate);
            event.cursorTransaction().invalidate();
            if (event instanceof CraftItemEvent.Preview) {
                ((CraftItemEvent.Preview)event).preview().invalidate();
            }
            return true;
        }
        boolean cancelledAny = false;
        for (SlotTransaction transaction : event.transactions()) {
            if (transaction.isValid()) continue;
            cancelledAny = true;
            for (GameTransaction gameTransaction : gameTransactions) {
                ((ContainerBasedTransaction)gameTransaction).getSlotTransactions().forEach(tx -> {
                    if (tx == transaction) {
                        gameTransaction.markCancelled();
                    }
                });
            }
        }
        return cancelledAny;
    }

    protected void handleEventResults(PlayerEntity player, ClickContainerEvent event) {
        PacketPhaseUtil.handleSlotRestore(player, this.menu, event.transactions(), event.isCancelled());
        PacketPhaseUtil.handleCursorRestore(player, event.cursorTransaction());
        if (this.entities != null && event instanceof SpawnEntityEvent) {
            EntityUtil.despawnFilteredEntities(this.entities, (SpawnEntityEvent)((Object)event));
        }
        if (!(event.isCancelled() || event instanceof CraftItemEvent.Craft || event instanceof CraftItemEvent.Preview)) {
            this.handleCrafting(player, event);
            this.handleCraftingPreview(player, event);
        }
    }

    private void handleCrafting(PlayerEntity player, ClickContainerEvent event) {
        if (this.craftedStack != null && this.craftingInventory != null) {
            if (this.acceptedTransactions != null) {
                this.acceptedTransactions.clear();
            }
            ItemStackSnapshot craftedItem = null;
            for (SlotTransaction transaction : event.transactions()) {
                if (!transaction.slot().equals(this.craftingInventory.result())) continue;
                craftedItem = (ItemStackSnapshot)transaction.original();
                break;
            }
            if (craftedItem == null) {
                craftedItem = ItemStackUtil.snapshotOf(this.craftedStack);
            }
            CraftItemEvent.Craft craftEvent = SpongeEventFactory.createCraftItemEventCraft(PhaseTracker.getCauseStackManager().currentCause(), ContainerUtil.fromNative(this.menu), craftedItem, this.craftingInventory, event.cursorTransaction(), Optional.ofNullable(this.onTakeRecipe), Optional.of(this.craftingInventory.result()), event.transactions());
            SpongeCommon.post(craftEvent);
            this.handleEventResults(player, craftEvent);
            if (craftEvent.isCancelled() && this.shiftCraftingResult != null) {
                this.shiftCraftingResult.func_190920_e(0);
            }
        }
    }

    private void handleCraftingPreview(PlayerEntity player, ClickContainerEvent event) {
        if (this.craftingInventory != null) {
            SlotTransaction previewTransaction = this.getPreviewTransaction(this.craftingInventory.result(), event.transactions());
            Optional<CraftingRecipe> recipe = player.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftingContainer, player.field_70170_p).map(CraftingRecipe.class::cast);
            CraftItemEvent.Preview previewEvent = SpongeEventFactory.createCraftItemEventPreview(event.cause(), (Container)this.menu, this.craftingInventory, event.cursorTransaction(), previewTransaction, recipe, Optional.empty(), event.transactions());
            SpongeCommon.post(previewEvent);
            this.handleEventResults(player, previewEvent);
            if (player instanceof ServerPlayerEntity && previewEvent instanceof CraftItemEvent.Preview) {
                SlotTransaction preview = previewEvent.preview();
                if (!preview.isValid() || previewEvent.isCancelled()) {
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(0, 0, ItemStackUtil.fromSnapshotToNative((ItemStackSnapshot)previewEvent.preview().original())));
                } else if (preview.custom().isPresent()) {
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(0, 0, ItemStackUtil.fromSnapshotToNative((ItemStackSnapshot)previewEvent.preview().finalReplacement())));
                }
            }
        }
    }

    protected SlotTransaction getPreviewTransaction(CraftingOutput result, List<SlotTransaction> slotTransactions) {
        @Nullable SlotTransaction preview = this.findPreviewTransaction(result, slotTransactions);
        if (preview == null) {
            ItemStackSnapshot previewItem = ItemStackUtil.snapshotOf(result.peek());
            return new SlotTransaction(result, previewItem, previewItem);
        }
        return preview;
    }

    private @Nullable SlotTransaction findPreviewTransaction(CraftingOutput result, List<SlotTransaction> slotTransactions) {
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!result.viewedSlot().equals(slotTransaction.slot().viewedSlot())) continue;
            return slotTransaction;
        }
        return null;
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    List<SlotTransaction> getSlotTransactions() {
        return this.acceptedTransactions == null ? Collections.emptyList() : this.acceptedTransactions;
    }

    @Override
    public boolean absorbSlotTransaction(ContainerSlotTransaction slotTransaction) {
        if (this.menu != slotTransaction.menu) {
            return false;
        }
        if (this.acceptedTransactions == null) {
            this.acceptedTransactions = new ArrayList<SlotTransaction>();
        }
        this.acceptedTransactions.add(slotTransaction.transaction);
        return true;
    }

    @Override
    public boolean absorbSpawnEntity(PhaseContext<@NonNull ?> context, SpawnEntityTransaction spawn) {
        if (context.doesContainerCaptureEntitySpawn(spawn.entityToSpawn)) {
            if (this.entities == null) {
                this.entities = new LinkedList<net.minecraft.entity.Entity>();
            }
            this.entities.add(spawn.entityToSpawn);
            return true;
        }
        return super.absorbSpawnEntity(context, spawn);
    }

    @Override
    public boolean acceptCraftingPreview(PhaseContext<@NonNull ?> ctx, CraftingPreviewTransaction transaction) {
        if (this.menu == transaction.menu) {
            this.craftingInventory = transaction.craftingInventory;
            this.craftingContainer = transaction.craftSlots;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptCrafting(PhaseContext<@NonNull ?> ctx, CraftingTransaction transaction) {
        if (this.menu == transaction.menu) {
            this.used = false;
            this.craftedStack = transaction.craftedStack;
            this.craftingInventory = transaction.craftingInventory;
            this.onTakeRecipe = transaction.recipe;
            return true;
        }
        return false;
    }

    @Override
    public boolean absorbShiftClickResult(PhaseContext<@NonNull ?> context, ShiftCraftingResultTransaction transaction) {
        this.shiftCraftingResult = transaction.itemStack;
        return true;
    }
}

