/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipeType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.CraftItemEvent;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerBasedTransaction;
import org.spongepowered.common.inventory.util.ContainerUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

public class CraftingPreviewTransaction
extends ContainerBasedTransaction {
    final PlayerEntity player;
    final CraftingInventory craftingInventory;
    final net.minecraft.inventory.CraftingInventory craftSlots;

    public CraftingPreviewTransaction(ServerPlayerEntity player, CraftingInventory craftingInventory, net.minecraft.inventory.CraftingInventory craftSlots) {
        super(player.field_71070_bA);
        this.player = player;
        this.craftingInventory = craftingInventory;
        this.craftSlots = craftSlots;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptCraftingPreview(ctx, this));
    }

    @Override
    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause currentCause) {
        if (slotTransactions.isEmpty()) {
            return Optional.empty();
        }
        ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(this.player.field_71071_by.func_70445_o());
        SlotTransaction previewTransaction = this.getPreviewTransaction(this.craftingInventory.result(), slotTransactions);
        Optional<CraftingRecipe> recipe = this.player.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftSlots, this.player.field_70170_p).map(CraftingRecipe.class::cast);
        CraftItemEvent.Preview event = SpongeEventFactory.createCraftItemEventPreview(currentCause, ContainerUtil.fromNative(this.menu), this.craftingInventory, new Transaction<ItemStackSnapshot>(cursor, cursor), previewTransaction, recipe, Optional.empty(), slotTransactions);
        return Optional.of(event);
    }

    @Override
    public boolean shouldHaveBeenAbsorbed() {
        return false;
    }
}

