/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.container.InteractContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerSlotTransaction;
import org.spongepowered.common.event.tracking.context.transaction.inventory.SetPlayerContainerTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.PrettyPrinter;

public class OpenMenuTransaction
extends GameTransaction<InteractContainerEvent> {
    private final ServerPlayerEntity player;
    private final ItemStackSnapshot cursor;
    private net.minecraft.inventory.container.Container menu;

    public OpenMenuTransaction(PlayerEntity player) {
        super(TransactionTypes.INTERACT_CONTAINER_EVENT.get());
        this.player = (ServerPlayerEntity)player;
        this.menu = player.field_71070_bA;
        this.cursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> frame.pushCause(this.menu));
    }

    @Override
    public Optional<InteractContainerEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<InteractContainerEvent>> gameTransactions, Cause currentCause) {
        ItemStackSnapshot resultingCursor = ItemStackUtil.snapshotOf(this.player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(this.cursor, resultingCursor);
        InteractContainerEvent.Open event = SpongeEventFactory.createInteractContainerEventOpen(currentCause, (Container)this.menu, cursorTransaction);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        PacketPhaseUtil.handleCursorRestore((PlayerEntity)this.player, event.cursorTransaction());
        this.player.func_71053_j();
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, InteractContainerEvent event) {
        PacketPhaseUtil.handleCursorRestore((PlayerEntity)this.player, event.cursorTransaction());
    }

    @Override
    public boolean markCancelledTransactions(InteractContainerEvent event, ImmutableList<? extends GameTransaction<InteractContainerEvent>> gameTransactions) {
        if (event.isCancelled()) {
            event.cursorTransaction().invalidate();
            return true;
        }
        return !event.cursorTransaction().isValid();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public boolean absorbContainerSet(PhaseContext<@NonNull ?> ctx, SetPlayerContainerTransaction transaction) {
        if (this.player != transaction.player) {
            return false;
        }
        this.menu = transaction.menu;
        return true;
    }

    @Override
    public boolean absorbSlotTransaction(ContainerSlotTransaction slotTransaction) {
        return true;
    }
}

