/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.inventory.InventoryBasedTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;

public class PlayerInventoryTransaction
extends InventoryBasedTransaction {
    private final ServerPlayerEntity player;
    private final EventCreator eventCreator;

    public PlayerInventoryTransaction(PlayerEntity player, EventCreator eventCreator) {
        super((Inventory)player.field_71071_by);
        this.player = (ServerPlayerEntity)player;
        this.eventCreator = eventCreator;
    }

    @Override
    Optional<ChangeInventoryEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        if (!entities.isEmpty()) {
            SpongeCommon.logger().warn("Entities are being captured but not being processed");
        }
        if (slotTransactions.isEmpty()) {
            return Optional.empty();
        }
        ChangeInventoryEvent event = this.eventCreator.create(cause, this.inventory, slotTransactions);
        return Optional.of(event);
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        PacketPhaseUtil.handleSlotRestore((PlayerEntity)this.player, null, event.transactions(), event.isCancelled());
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ChangeInventoryEvent event) {
        PacketPhaseUtil.handleSlotRestore((PlayerEntity)this.player, null, event.transactions(), event.isCancelled());
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.absorbPlayerInventoryChange(ctx, this));
    }

    @Override
    public boolean absorbPlayerInventoryChange(PhaseContext<@NonNull ?> context, PlayerInventoryTransaction playerInventoryTransaction) {
        if (playerInventoryTransaction.player == this.player) {
            return this.eventCreator == playerInventoryTransaction.eventCreator;
        }
        return false;
    }

    public static interface EventCreator {
        public static final EventCreator STANDARD = SpongeEventFactory::createChangeInventoryEvent;
        public static final EventCreator PICKUP = SpongeEventFactory::createChangeInventoryEventPickup;
        public static final EventCreator SWAP_HAND = SpongeEventFactory::createChangeInventoryEventSwapHand;

        public ChangeInventoryEvent create(Cause var1, Inventory var2, List<SlotTransaction> var3);
    }
}

