/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.inventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.item.MerchantOffer;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.inventory.ContainerBasedTransaction;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SelectTradeTransaction
extends ContainerBasedTransaction {
    private final ServerPlayerEntity player;
    private int tradeItem;

    public SelectTradeTransaction(ServerPlayerEntity player, int tradeItem) {
        super(player.field_71070_bA);
        this.player = player;
        this.tradeItem = tradeItem;
    }

    @Override
    Optional<ClickContainerEvent> createInventoryEvent(List<SlotTransaction> slotTransactions, List<Entity> entities, PhaseContext<@NonNull ?> context, Cause cause) {
        ItemStackSnapshot cursorItem = ItemStackUtil.snapshotOf(this.player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(cursorItem, cursorItem);
        if (this.menu instanceof MerchantContainer) {
            MerchantOffer offer = (MerchantOffer)((MerchantContainer)this.menu).func_217051_h().get(this.tradeItem);
            ClickContainerEvent.SelectTrade event = SpongeEventFactory.createClickContainerEventSelectTrade(cause, (Container)this.menu, cursorTransaction, Optional.empty(), (TradeOffer)offer, slotTransactions, this.tradeItem);
            return Optional.of(event);
        }
        SpongeCommon.logger().warn("SelectTradeTransaction without MerchantMenu");
        return Optional.empty();
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((PlayerEntity)this.player, event);
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, ClickContainerEvent event) {
        this.handleEventResults((PlayerEntity)this.player, event);
    }

    @Override
    boolean isContainerEventAllowed(PhaseContext<@NonNull ?> context) {
        if (!(context instanceof InventoryPacketContext)) {
            return false;
        }
        int containerId = ((CPlaceRecipePacket)((InventoryPacketContext)context).getPacket()).func_194318_a();
        return containerId != this.player.field_71070_bA.field_75152_c;
    }
}

