/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.world;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.DamageSource;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.HarvestEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.damagesource.CombatEntryAccessor;
import org.spongepowered.common.accessor.world.damagesource.CombatTrackerAccessor;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.volume.VolumeStreamUtils;

public final class EntityPerformingDropsTransaction
extends WorldBasedTransaction<HarvestEntityEvent> {
    private @MonotonicNonNull Supplier<net.minecraft.world.server.ServerWorld> worldSupplier;
    final Entity destroyingEntity;
    private @MonotonicNonNull CompoundNBT entityTag;
    private @MonotonicNonNull Supplier<Optional<DamageSource>> lastAttacker;

    public EntityPerformingDropsTransaction(Entity destroyingEntity) {
        super(TransactionTypes.ENTITY_DEATH_DROPS.get(), ((ServerWorld)destroyingEntity.field_70170_p).key());
        this.destroyingEntity = destroyingEntity;
    }

    @Override
    protected void captureState() {
        CombatEntry entry;
        super.captureState();
        Entity entity = this.destroyingEntity;
        this.worldSupplier = VolumeStreamUtils.createWeaklyReferencedSupplier((net.minecraft.world.server.ServerWorld)entity.field_70170_p, "ServerLevel");
        CompoundNBT tag = new CompoundNBT();
        entity.func_189511_e(tag);
        this.entityTag = tag;
        @Nullable DamageSource lastAttacker = entity instanceof LivingEntity ? ((entry = ((CombatTrackerAccessor)((LivingEntity)entity).func_110142_aN()).invoker$getMostSignificantFall()) != null ? ((CombatEntryAccessor)entry).accessor$source() : null) : null;
        WeakReference<@Nullable Object> ref = new WeakReference<Object>(lastAttacker);
        this.lastAttacker = () -> {
            @Nullable DamageSource damageSource = (DamageSource)ref.get();
            if (damageSource == null) {
                return Optional.empty();
            }
            return Optional.of(damageSource);
        };
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptEntityDrops(this.destroyingEntity));
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, stackFrame) -> {
            stackFrame.pushCause(this.destroyingEntity);
            this.lastAttacker.get().ifPresent(attacker -> stackFrame.addContext(EventContextKeys.LAST_DAMAGE_SOURCE, (org.spongepowered.api.event.cause.entity.damage.source.DamageSource)attacker));
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    public boolean acceptEntityDrops(Entity entity) {
        return this.destroyingEntity == entity;
    }

    @Override
    public boolean isUnbatchable() {
        return true;
    }

    @Override
    public Optional<HarvestEntityEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<HarvestEntityEvent>> gameTransactions, Cause currentCause) {
        return Optional.of(SpongeEventFactory.createHarvestEntityEvent(currentCause, (org.spongepowered.api.entity.Entity)this.destroyingEntity));
    }

    @Override
    public void restore(PhaseContext<?> context, HarvestEntityEvent event) {
        this.destroyingEntity.func_200600_R().func_220342_a(this.worldSupplier.get(), this.entityTag, null, null, this.destroyingEntity.func_233580_cy_(), SpawnReason.COMMAND, false, false);
    }

    @Override
    public boolean markCancelledTransactions(HarvestEntityEvent event, ImmutableList<? extends GameTransaction<HarvestEntityEvent>> gameTransactions) {
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", EntityPerformingDropsTransaction.class.getSimpleName() + "[", "]").add("destroyingEntity=" + this.destroyingEntity).add("lastAttacker=" + this.lastAttacker).add("worldKey=" + this.worldKey).add("cancelled=" + this.cancelled).toString();
    }
}

