/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;
import org.spongepowered.common.world.BlockChange;

final class CommandState
extends GeneralState<CommandPhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> COMMAND_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.commandMapping != null) {
            frame.pushCause(ctx.commandMapping);
        }
    });

    CommandState() {
    }

    @Override
    public CommandPhaseContext createNewContext(PhaseTracker tracker) {
        return new CommandPhaseContext(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, CommandPhaseContext> getFrameModifier() {
        return this.COMMAND_MODIFIER;
    }

    @Override
    public void postBlockTransactionApplication(CommandPhaseContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        PhaseTracker.getCauseStackManager().currentCause().first(Player.class).ifPresent(user -> TrackingUtil.associateTrackerToTarget(blockChange, transaction, user.uniqueId()));
    }

    @Override
    public void associateNeighborStateNotifier(CommandPhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        context.getSource(Player.class).ifPresent(player -> ((LevelChunkBridge)minecraftWorld.func_175726_f(notifyPos)).bridge$addTrackedBlockPosition(block, notifyPos, player.uniqueId(), PlayerTracker.Type.NOTIFIER));
    }

    @Override
    public void unwind(CommandPhaseContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(CommandPhaseContext context) {
        Optional<PlayerEntity> playerSource = context.getSource(PlayerEntity.class);
        if (playerSource.isPresent()) {
            return () -> (ResourceKey)((PlayerEntity)playerSource.get()).field_70170_p.func_234923_W_().func_240901_a_();
        }
        return super.attemptWorldKey(context);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(CommandPhaseContext context, Entity entityToSpawn) {
        return SpawnTypes.PLACEMENT;
    }
}

