/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.world.Explosion;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.accessor.world.level.ExplosionAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;

final class ExplosionState
extends GeneralState<ExplosionContext> {
    private final BiConsumer<CauseStackManager.StackFrame, ExplosionContext> EXPLOSION_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        Entity exploder;
        Explosion explosion = context.getExplosion();
        @Nullable LivingEntity placedBy = explosion.func_94613_c();
        if (placedBy != null) {
            if (placedBy instanceof CreatorTrackedBridge) {
                ((CreatorTrackedBridge)placedBy).tracker$getCreatorUUID().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                ((CreatorTrackedBridge)placedBy).tracker$getNotifierUUID().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
            frame.addContext(EventContextKeys.IGNITER, (Living)placedBy);
        }
        if ((exploder = ((ExplosionAccessor)explosion).accessor$source()) != null) {
            frame.pushCause(exploder);
        }
        frame.pushCause(explosion);
    });

    ExplosionState() {
    }

    @Override
    public ExplosionContext createNewContext(PhaseTracker tracker) {
        return new ExplosionContext(tracker).populateFromCurrentState();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, ExplosionContext> getFrameModifier() {
        return this.EXPLOSION_MODIFIER;
    }

    @Override
    public void populateLootContext(ExplosionContext phaseContext, LootContext.Builder lootBuilder) {
        Explosion explosion = phaseContext.getExplosion();
        lootBuilder.func_216021_b(LootParameters.field_216281_a, (Object)((ExplosionAccessor)explosion).accessor$source());
        if (((ExplosionAccessor)explosion).accessor$blockInteraction() == Explosion.Mode.DESTROY) {
            lootBuilder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(((ExplosionAccessor)explosion).accessor$radius()));
        }
    }

    @Override
    public void unwind(ExplosionContext context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public SpawnEntityEvent createSpawnEvent(ExplosionContext context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        if (parent instanceof ChangeBlock) {
            return SpongeEventFactory.createDropItemEventDestruct(currentCause, collect.stream().map(t2 -> (org.spongepowered.api.entity.Entity)t2.first()).collect(Collectors.toList()));
        }
        return super.createSpawnEvent(context, parent, collect, currentCause);
    }
}

