/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.generation;

import java.util.Objects;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.PrettyPrinter;

public abstract class GenerationContext<G extends GenerationContext<G>>
extends PhaseContext<G> {
    private @Nullable ServerWorld world;
    private @Nullable ChunkGenerator generator;

    GenerationContext(IPhaseState<G> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    @Override
    protected void reset() {
        super.reset();
        this.world = null;
        this.generator = null;
    }

    public final G world(ServerWorld world) {
        this.world = Objects.requireNonNull(world);
        return (G)this;
    }

    public final ServerWorld getWorld() {
        return Objects.requireNonNull(this.world);
    }

    public final G generator(ChunkGenerator generator) {
        this.generator = Objects.requireNonNull(generator);
        return (G)this;
    }

    public final ChunkGenerator getGenerator() {
        return Objects.requireNonNull(this.generator);
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s2 = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s2 + "- %s: %s", "World", this.world).add(s2 + "- %s: %s", "Generator", this.generator);
    }
}

