/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.TransactionalCaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.effect.BroadcastInventoryChangesEffect;
import org.spongepowered.common.event.tracking.context.transaction.inventory.PlayerInventoryTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.util.PrettyPrinter;

public class PacketContext<P extends PacketContext<P>>
extends PhaseContext<P> {
    protected ServerPlayerEntity packetPlayer;
    @Nullable IPacket<?> packet;
    private ItemStack itemUsed = ItemStack.empty();
    private ItemStackSnapshot itemUsedSnapshot = ItemStackSnapshot.empty();
    private @Nullable HandType handUsed;
    private boolean interactItemChanged;

    protected PacketContext(PacketState<P> state, PhaseTracker tracker) {
        super(state, tracker);
    }

    public P packet(IPacket<?> packet) {
        this.packet = packet;
        return (P)this;
    }

    public P packetPlayer(ServerPlayerEntity playerMP) {
        this.packetPlayer = playerMP;
        return (P)this;
    }

    public ServerPlayerEntity getPacketPlayer() {
        return this.packetPlayer;
    }

    public ServerPlayer getSpongePlayer() {
        return (ServerPlayer)this.packetPlayer;
    }

    public <K extends IPacket<?>> K getPacket() {
        return (K)this.packet;
    }

    public P itemUsed(ItemStack stack) {
        this.itemUsed = stack;
        this.itemUsedSnapshot = this.itemUsed.createSnapshot();
        return (P)this;
    }

    public ItemStack getItemUsed() {
        return this.itemUsed;
    }

    public ItemStackSnapshot getItemUsedSnapshot() {
        return this.itemUsedSnapshot;
    }

    public P interactItemChanged(boolean changed) {
        this.interactItemChanged = changed;
        return (P)this;
    }

    public boolean getInteractItemChanged() {
        return this.interactItemChanged;
    }

    public P handUsed(HandType hand) {
        this.handUsed = hand;
        return (P)this;
    }

    public HandType getHandUsed() {
        return this.handUsed;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s2 = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s2 + "- %s: %s", "PacketPlayer", this.packetPlayer).add(s2 + "- %s: %s", "Packet", this.packet).add(s2 + "- %s: %s", "ItemStackUsed", this.itemUsed);
    }

    @Override
    public boolean hasCaptures() {
        if (((PacketState)this.state).alwaysUnwinds()) {
            return true;
        }
        return super.hasCaptures();
    }

    @Override
    public void close() {
        TransactionalCaptureSupplier transactor = this.getTransactor();
        if (this.packetPlayer != null) {
            transactor.logPlayerInventoryChange((PlayerEntity)this.packetPlayer, PlayerInventoryTransaction.EventCreator.STANDARD);
            try (EffectTransactor ignored = BroadcastInventoryChangesEffect.transact(transactor);){
                this.packetPlayer.field_71070_bA.func_75142_b();
            }
        }
        super.close();
    }

    @Override
    protected void reset() {
        super.reset();
        this.packetPlayer = null;
        this.packet = null;
        this.itemUsed = ItemStack.empty();
        this.itemUsedSnapshot = ItemStackSnapshot.empty();
        this.handUsed = null;
        this.interactItemChanged = false;
    }
}

