/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.accessor.entity.passive.AbstractChestedHorseEntityAccessor;
import org.spongepowered.common.accessor.network.protocol.game.ServerboundMovePlayerPacketAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.accessor.world.entity.animal.PigAccessor;
import org.spongepowered.common.accessor.world.entity.animal.SheepAccessor;
import org.spongepowered.common.accessor.world.entity.animal.WolfAccessor;
import org.spongepowered.common.accessor.world.inventory.SlotAccessor;
import org.spongepowered.common.bridge.world.level.block.TrackableBlockBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class PacketPhaseUtil {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void handleSlotRestore(@Nullable PlayerEntity player, @Nullable Container containerMenu, List<SlotTransaction> slotTransactions, boolean eventCancelled) {
        try (@NonNull P ignored = ((PhaseContext)BlockPhase.State.RESTORING_BLOCKS.createPhaseContext(PhaseTracker.SERVER)).buildAndSwitch();){
            boolean restoredAny = false;
            for (SlotTransaction slotTransaction : slotTransactions) {
                ItemStackSnapshot snapshot;
                if (!slotTransaction.custom().isPresent() && slotTransaction.isValid() && !eventCancelled) continue;
                restoredAny = true;
                Slot slot = slotTransaction.slot();
                ItemStackSnapshot itemStackSnapshot = snapshot = eventCancelled || !slotTransaction.isValid() ? (ItemStackSnapshot)slotTransaction.original() : (ItemStackSnapshot)slotTransaction.custom().get();
                if (containerMenu == null || slot.viewedSlot() == slot) {
                    slot.set(snapshot.createStack());
                    continue;
                }
                int slotNumber = ((SlotAdapter)slot).getOrdinal();
                net.minecraft.inventory.container.Slot nmsSlot = containerMenu.func_75139_a(slotNumber);
                if (nmsSlot == null) continue;
                nmsSlot.func_75215_d(ItemStackUtil.fromSnapshotToNative(snapshot));
            }
            if (restoredAny && player instanceof ServerPlayerEntity) {
                if (containerMenu != null) {
                    containerMenu.func_75142_b();
                    if (player.field_71070_bA == containerMenu) {
                        ((ServerPlayerEntity)player).func_71120_a(containerMenu);
                    }
                } else {
                    player.field_71069_bz.func_75142_b();
                }
            }
        }
    }

    public static void handleCursorRestore(PlayerEntity player, Transaction<ItemStackSnapshot> cursorTransaction) {
        ItemStackSnapshot cursorSnap;
        if (!cursorTransaction.isValid()) {
            cursorSnap = cursorTransaction.original();
        } else if (cursorTransaction.custom().isPresent()) {
            cursorSnap = cursorTransaction.finalReplacement();
        } else {
            return;
        }
        ItemStack cursor = ItemStackUtil.fromSnapshotToNative(cursorSnap);
        player.field_71071_by.func_70437_b(cursor);
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, cursor));
        }
    }

    public static void handleCustomCursor(PlayerEntity player, ItemStackSnapshot customCursor) {
        ItemStack cursor = ItemStackUtil.fromSnapshotToNative(customCursor);
        player.field_71071_by.func_70437_b(cursor);
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, cursor));
        }
    }

    public static void validateCapturedTransactions(int slotId, Container containerMenu, List<SlotTransaction> capturedTransactions) {
        net.minecraft.inventory.container.Slot slot;
        if (capturedTransactions.size() == 0 && slotId >= 0 && slotId < containerMenu.field_75151_b.size() && (slot = containerMenu.func_75139_a(slotId)) != null) {
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(slot.func_75211_c());
            SlotTransaction slotTransaction = new SlotTransaction(((InventoryAdapter)containerMenu).inventoryAdapter$getSlot(slotId).get(), snapshot, snapshot);
            capturedTransactions.add(slotTransaction);
        }
    }

    public static void handlePlayerSlotRestore(ServerPlayerEntity player, ItemStack itemStack, Hand hand) {
        if (itemStack.func_190926_b()) {
            return;
        }
        player.field_71137_h = false;
        int slotId = 0;
        if (hand == Hand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)itemStack);
            slotId = player.field_71071_by.field_70462_a.size() + PlayerInventory.func_70451_h();
        } else {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)itemStack);
            for (net.minecraft.inventory.container.Slot containerSlot : player.field_71070_bA.field_75151_b) {
                if (containerSlot.field_75224_c != player.field_71071_by || ((SlotAccessor)containerSlot).accessor$slot() != player.field_71071_by.field_70461_c) continue;
                slotId = containerSlot.field_75222_d;
                break;
            }
        }
        player.field_71070_bA.func_75142_b();
        player.field_71137_h = false;
        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(player.field_71070_bA.field_75152_c, slotId, itemStack));
    }

    public static boolean allTransactionsInvalid(List<SlotTransaction> slotTransactions) {
        if (slotTransactions.size() == 0) {
            return false;
        }
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.isValid()) continue;
            return false;
        }
        return true;
    }

    public static void onProcessPacket(IPacket packetIn, INetHandler netHandler) {
        if (netHandler instanceof ServerPlayNetHandler) {
            ServerPlayerEntity packetPlayer = ((ServerPlayNetHandler)netHandler).field_147369_b;
            if (!(packetPlayer.func_70089_S() || packetIn instanceof CCustomPayloadPacket || packetIn instanceof CClientStatusPacket && ((CClientStatusPacket)packetIn).func_149435_c() == CClientStatusPacket.State.PERFORM_RESPAWN)) {
                return;
            }
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                boolean ignoreMovementCapture;
                frame.pushCause(packetPlayer);
                if (packetIn instanceof CPlayerPacket) {
                    CPlayerPacket movingPacket = (CPlayerPacket)packetIn;
                    ignoreMovementCapture = movingPacket instanceof CPlayerPacket.RotationPacket ? true : packetPlayer.func_226277_ct_() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$x() && packetPlayer.func_226278_cu_() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$y() && packetPlayer.func_226281_cx_() == ((ServerboundMovePlayerPacketAccessor)movingPacket).accessor$z();
                    if (ignoreMovementCapture) {
                        AxisAlignedBB boundingBox = packetPlayer.func_174813_aQ();
                        BlockPos min2 = new BlockPos(boundingBox.field_72340_a + 0.001, boundingBox.field_72338_b + 0.001, boundingBox.field_72339_c + 0.001);
                        BlockPos max = new BlockPos(boundingBox.field_72336_d - 0.001, boundingBox.field_72337_e - 0.001, boundingBox.field_72334_f - 0.001);
                        BlockPos.Mutable pos = new BlockPos.Mutable();
                        if (packetPlayer.field_70170_p.func_175707_a(min2, max)) {
                            for (int x = min2.func_177958_n(); x <= max.func_177958_n(); ++x) {
                                for (int y = min2.func_177956_o(); y <= max.func_177956_o(); ++y) {
                                    for (int z = min2.func_177952_p(); z <= max.func_177952_p(); ++z) {
                                        pos.func_181079_c(x, y, z);
                                        Block block = packetPlayer.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c();
                                        if (!((TrackableBlockBridge)block).bridge$hasEntityInsideLogic()) continue;
                                        ignoreMovementCapture = false;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    ignoreMovementCapture = false;
                }
                if (ignoreMovementCapture || packetIn instanceof CClientSettingsPacket) {
                    packetIn.func_148833_a(netHandler);
                }
                IPhaseState<PacketContext<?>> packetState = PacketPhase.getInstance().getStateForPacket(packetIn);
                PacketContext<?> context = packetState.createPhaseContext(PhaseTracker.SERVER);
                ((PacketContext)((PacketContext)context.source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn);
                if (!PacketPhase.getInstance().isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    PacketPhase.getInstance().populateContext(packetIn, packetPlayer, packetState, context);
                    context.creator(((ServerPlayer)packetPlayer).uniqueId());
                    context.notifier(((ServerPlayer)packetPlayer).uniqueId());
                }
                try (PacketContext<?> packetContext = context;){
                    packetContext.buildAndSwitch();
                    packetIn.func_148833_a(netHandler);
                }
            }
        } else {
            packetIn.func_148833_a(netHandler);
        }
    }

    public static @Nullable DataParameter<?> findModifiedEntityInteractDataParameter(ItemStack stack, Entity entity) {
        Item item = stack.func_77973_b();
        if (item instanceof DyeItem) {
            if (entity instanceof SheepEntity) {
                return SheepAccessor.accessor$DATA_WOOL_ID();
            }
            if (entity instanceof WolfEntity) {
                return WolfAccessor.accessor$DATA_COLLAR_COLOR();
            }
            return null;
        }
        if (item == Items.field_151057_cb) {
            return entity instanceof LivingEntity && !(entity instanceof PlayerEntity) && stack.func_82837_s() ? EntityAccessor.accessor$DATA_CUSTOM_NAME() : null;
        }
        if (item == Items.field_151141_av) {
            return entity instanceof PigEntity ? PigAccessor.accessor$DATA_SADDLE_ID() : null;
        }
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() == Blocks.field_150486_ae) {
            return entity instanceof AbstractChestedHorseEntity ? AbstractChestedHorseEntityAccessor.accessor$DATA_ID_CHEST() : null;
        }
        return null;
    }
}

