/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;

public abstract class PacketState<P extends PacketContext<P>>
extends PooledPhaseState<P>
implements IPhaseState<P> {
    private final BiConsumer<CauseStackManager.StackFrame, P> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        if (ctx.packetPlayer != null) {
            frame.pushCause(ctx.packetPlayer);
        }
    });
    private final String desc = TrackingUtil.phaseStateToString("Packet", this);

    protected PacketState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, P> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public void unwind(P phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    public boolean matches(int packetState) {
        return false;
    }

    @Override
    public void associateNeighborStateNotifier(P unwindingContext, BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        ServerPlayer player = ((PacketContext)unwindingContext).getSpongePlayer();
        Chunk chunk = minecraftWorld.func_175726_f(notifyPos);
        ((LevelChunkBridge)chunk).bridge$setBlockNotifier(notifyPos, player.uniqueId());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(P context, Entity entityToSpawn) {
        return SpawnTypes.PLACEMENT;
    }

    @Override
    public void associateScheduledTickUpdate(P asContext, ServerWorld level, NextTickListEntry<?> entry) {
        ((PhaseContext)asContext).getTransactor().logScheduledUpdate(level, entry);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(P context) {
        ResourceLocation worldKey = ((PacketContext)context).packetPlayer.func_71121_q().func_234923_W_().func_240901_a_();
        return () -> (ResourceKey)worldKey;
    }

    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, P context) {
    }

    public boolean isPacketIgnored(IPacket<?> packetIn, ServerPlayerEntity packetPlayer) {
        return false;
    }

    protected boolean alwaysUnwinds() {
        return false;
    }

    public String toString() {
        return this.desc;
    }
}

