/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class DropInventoryState
extends BasicInventoryPacketState {
    @Override
    public BiConsumer<CauseStackManager.StackFrame, InventoryPacketContext> getFrameModifier() {
        return super.getFrameModifier().andThen((frame, ctx) -> {
            ItemStack usedStack = ctx.getItemUsed();
            ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
            if (!usedSnapshot.isEmpty()) {
                frame.addContext(EventContextKeys.USED_ITEM, usedSnapshot);
            }
        });
    }

    @Override
    public SpawnEntityEvent createSpawnEvent(InventoryPacketContext context, GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        return SpongeEventFactory.createDropItemEventDispense(currentCause, collect.stream().map(Tuple::first).map(entity -> (org.spongepowered.api.entity.Entity)entity).collect(Collectors.toList()));
    }
}

