/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.item.inventory.container.ClickContainerEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.util.Constants;

public final class DropItemInsideWindowState
extends BasicInventoryPacketState {
    public DropItemInsideWindowState() {
        super(Constants.Networking.MODE_DROP | 1 | 2 | 0x10000);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, InventoryPacketContext> getFrameModifier() {
        return super.getFrameModifier().andThen((frame, context) -> frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM));
    }

    public ClickContainerEvent.Drop createContainerEvent(InventoryPacketContext context, Cause cause, ServerPlayerEntity serverPlayer, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<org.spongepowered.api.entity.Entity> capturedEntities, int usedButton, @Nullable Slot slot) {
        TrackingUtil.setCreatorReference(capturedEntities, serverPlayer);
        if (usedButton == 0) {
            return SpongeEventFactory.createClickContainerEventDropSingle(cause, openContainer, transaction, capturedEntities, Optional.ofNullable(slot), slotTransactions);
        }
        return SpongeEventFactory.createClickContainerEventDropFull(cause, openContainer, transaction, capturedEntities, Optional.ofNullable(slot), slotTransactions);
    }

    @Override
    public boolean doesContainerCaptureEntitySpawn(InventoryPacketContext context, Entity entityIn) {
        return true;
    }
}

