/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class AttackEntityPacketState
extends BasicPacketState {
    private final BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> ATTACK_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)ctx.getPacket();
        ServerPlayerEntity player = ctx.getPacketPlayer();
        @Nullable Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity != null) {
            frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
            frame.pushCause(entity);
        }
        frame.pushCause(player);
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.ATTACK_MODIFIER;
    }

    @Override
    public boolean isPacketIgnored(IPacket<?> packetIn, ServerPlayerEntity packetPlayer) {
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)packetIn;
        @Nullable Entity entity = useEntityPacket.func_149564_a(packetPlayer.field_70170_p);
        return entity == null;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, BasicPacketContext context) {
        ((BasicPacketContext)context.itemUsed(ItemStackUtil.cloneDefensive(playerMP.func_184614_ca()))).handUsed(HandTypes.MAIN_HAND.get());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, Entity entityToSpawn) {
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)context.getPacket();
        ServerPlayerEntity player = context.getPacketPlayer();
        @Nullable Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
        if (entity != null && (entity.field_70128_L || entity instanceof LivingEntity && ((LivingEntity)entity).func_233643_dh_())) {
            return entityToSpawn instanceof ExperienceOrbEntity ? SpawnTypes.EXPERIENCE : SpawnTypes.DROPPED_ITEM;
        }
        if (entityToSpawn instanceof ItemEntity) {
            return SpawnTypes.DROPPED_ITEM;
        }
        return super.getSpawnTypeForTransaction(context, entityToSpawn);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        if (!TrackingUtil.processBlockCaptures(context)) {
            CUseEntityPacket useEntityPacket = (CUseEntityPacket)context.getPacket();
            ServerPlayerEntity player = context.getPacketPlayer();
            @Nullable Entity entity = useEntityPacket.func_149564_a(player.field_70170_p);
            if (entity instanceof org.spongepowered.api.entity.Entity) {
                ((org.spongepowered.api.entity.Entity)entity).offer(Keys.NOTIFIER, player.func_110124_au());
            }
        }
    }
}

