/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.accessor.world.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class InteractionPacketState
extends PacketState<InteractionPacketContext> {
    @Override
    public BiConsumer<CauseStackManager.StackFrame, InteractionPacketContext> getFrameModifier() {
        return super.getFrameModifier().andThen((frame, context) -> {
            ItemStack usedStack = context.getItemUsed();
            HandType usedHand = context.getHandUsed();
            ItemStackSnapshot usedSnapshot = ItemStackUtil.snapshotOf(usedStack);
            BlockSnapshot targetBlock = context.getTargetBlock();
            frame.addContext(EventContextKeys.USED_ITEM, usedSnapshot);
            frame.addContext(EventContextKeys.USED_HAND, usedHand);
            frame.addContext(EventContextKeys.BLOCK_HIT, targetBlock);
        });
    }

    @Override
    public InteractionPacketContext createNewContext(PhaseTracker tracker) {
        return new InteractionPacketContext(this, tracker);
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, InteractionPacketContext context) {
        BlockPos target;
        ItemStack itemInUse;
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.func_184614_ca());
        if (stack != null) {
            context.itemUsed(stack);
        }
        if ((itemInUse = ItemStackUtil.cloneDefensive(playerMP.func_184607_cu())) != null) {
            context.activeItem(itemInUse);
        }
        if (!playerMP.field_70170_p.func_195588_v(target = ((CPlayerDiggingPacket)packet).func_179715_a())) {
            context.targetBlock(BlockSnapshot.empty());
        } else {
            context.targetBlock(((TrackedWorldBridge)playerMP.field_70170_p).bridge$createSnapshot(target, BlockChangeFlags.NONE));
        }
        context.handUsed(HandTypes.MAIN_HAND.get());
    }

    @Override
    public void unwind(InteractionPacketContext phaseContext) {
        boolean hasBlocks;
        ServerPlayerEntity player = phaseContext.getPacketPlayer();
        net.minecraft.item.ItemStack endActiveItem = player.func_184607_cu();
        ((LivingEntityAccessor)player).accessor$useItem(ItemStackUtil.toNative(phaseContext.getActiveItem()));
        boolean bl = hasBlocks = !phaseContext.getTransactor().isEmpty();
        if (hasBlocks && !TrackingUtil.processBlockCaptures(phaseContext)) {
            return;
        }
        ((LivingEntityAccessor)player).accessor$useItem(endActiveItem);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(InteractionPacketContext context, Entity entityToSpawn) {
        return SpawnTypes.DROPPED_ITEM;
    }
}

