/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import com.google.common.collect.ImmutableList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.world.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.PlayerCommandPhaseContext;
import org.spongepowered.common.world.BlockChange;

public final class PacketCommandState
extends PacketState<PlayerCommandPhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, PlayerCommandPhaseContext> COMMAND_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        ctx.getSource(Object.class).ifPresent(frame::pushCause);
        if (ctx.command != null && !ctx.command.isEmpty()) {
            frame.addContext(EventContextKeys.COMMAND, ctx.command);
        }
    });

    @Override
    public PlayerCommandPhaseContext createNewContext(PhaseTracker tracker) {
        return new PlayerCommandPhaseContext(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, PlayerCommandPhaseContext> getFrameModifier() {
        return this.COMMAND_MODIFIER;
    }

    @Override
    public void postBlockTransactionApplication(PlayerCommandPhaseContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        PhaseTracker.getCauseStackManager().currentCause().first(Player.class).ifPresent(user -> TrackingUtil.associateTrackerToTarget(blockChange, transaction, user.uniqueId()));
    }

    @Override
    public SpawnEntityEvent createSpawnEvent(PlayerCommandPhaseContext context, GameTransaction<@NonNull ?> parent, ImmutableList<Tuple<Entity, SpawnEntityTransaction.DummySnapshot>> collect, Cause currentCause) {
        Cause newCauseWithSpawnType = Cause.builder().from(currentCause).build(EventContext.builder().from(currentCause.context()).add(EventContextKeys.SPAWN_TYPE, SpawnTypes.PLACEMENT.get()).build());
        return SpongeEventFactory.createSpawnEntityEvent(newCauseWithSpawnType, collect.stream().map(t2 -> (org.spongepowered.api.entity.Entity)t2.first()).collect(Collectors.toList()));
    }
}

