/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;

public final class PlaceBlockPacketState
extends BasicPacketState {
    private final BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, ctx.getSpongePlayer().world());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        frame.pushCause(ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, BasicPacketContext context) {
        CPlayerTryUseItemOnBlockPacket placeBlock = (CPlayerTryUseItemOnBlockPacket)packet;
        net.minecraft.item.ItemStack itemUsed = playerMP.func_184586_b(placeBlock.func_187022_c());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(itemUsed);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.func_187022_c();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BasicPacketContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        TrackingUtil.associateTrackerToTarget(blockChange, transaction, ((ServerPlayer)context.getPacketPlayer()).uniqueId());
    }

    @Override
    public void appendNotifierToBlockEvent(BasicPacketContext context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
        Player player = PhaseTracker.getCauseStackManager().currentCause().first(Player.class).get();
        BlockState state = ((ServerWorld)((Object)mixinWorldServer)).block(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world((ServerWorld)((Object)mixinWorldServer)).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state(state).build();
        blockEvent.bridge$setTickingLocatable(locatable);
        blockEvent.bridge$setSourceUserUUID(player.uniqueId());
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, Entity entityToSpawn) {
        ItemStack itemStack = context.getItemUsed();
        return itemStack.type() instanceof SpawnEggItem ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT;
    }
}

