/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

public final class UseItemPacketState
extends BasicPacketState {
    private BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = super.getFrameModifier().andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, ctx.getSpongePlayer().world());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        frame.pushCause(ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, BasicPacketContext context) {
        CPlayerTryUseItemPacket placeBlock = (CPlayerTryUseItemPacket)packet;
        net.minecraft.item.ItemStack usedItem = playerMP.func_184586_b(placeBlock.func_187028_a());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(usedItem);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.func_187028_a();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BasicPacketContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        ServerPlayer player = context.getSpongePlayer();
        BlockPos pos = VecHelper.toBlockPos(transaction.finalBlock().position());
        LevelChunkBridge spongeChunk = (LevelChunkBridge)((ServerWorld)player.world()).func_175726_f(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.bridge$addTrackedBlockPosition((Block)transaction.finalBlock().state().type(), pos, player.uniqueId(), PlayerTracker.Type.CREATOR);
        }
        spongeChunk.bridge$addTrackedBlockPosition((Block)transaction.finalBlock().state().type(), pos, player.uniqueId(), PlayerTracker.Type.NOTIFIER);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BasicPacketContext context, Entity entityToSpawn) {
        ItemStack itemStack = context.getItemUsed();
        return itemStack.type() instanceof SpawnEggItem ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT;
    }

    @Override
    public void unwind(BasicPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        ItemStackSnapshot snapshot = context.getItemUsedSnapshot();
        HandType hand = context.getHandUsed();
        ItemStack itemStack = context.getItemUsed();
        boolean success = TrackingUtil.processBlockCaptures(context);
        if (!success && snapshot.isEmpty()) {
            PhaseTracker.getCauseStackManager().pushCause(player);
            PacketPhaseUtil.handlePlayerSlotRestore(player, ItemStackUtil.toNative(itemStack), (Hand)hand);
        }
    }
}

