/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhaseContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhaseState;

class VolumeStreamApplicationState
extends PluginPhaseState<Context> {
    private final BiConsumer<CauseStackManager.StackFrame, Context> PLUGIN_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        if (context.stream != null) {
            frame.pushCause(context.stream);
        }
        context.getSource(Object.class).ifPresent(frame::pushCause);
    });

    VolumeStreamApplicationState() {
    }

    @Override
    public Context createNewContext(PhaseTracker tracker) {
        return new Context(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, Context> getFrameModifier() {
        return this.PLUGIN_MODIFIER;
    }

    @Override
    public void unwind(Context phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(Context context, Entity entityToSpawn) {
        return context.spawnTypeSupplier;
    }

    @Override
    public boolean isApplyingStreams() {
        return true;
    }

    public static class Context
    extends PluginPhaseContext<Context> {
        @MonotonicNonNull VolumeStream<@NonNull ?, ?> stream;
        @MonotonicNonNull Supplier<SpawnType> spawnTypeSupplier;

        Context(IPhaseState<Context> phaseState, PhaseTracker tracker) {
            super(phaseState, tracker);
        }

        public Context setVolumeStream(VolumeStream<@NonNull ?, ?> stream) {
            this.stream = stream;
            return this;
        }

        public Context spawnType(Supplier<@Nullable SpawnType> supplier) {
            @Nullable SpawnType spawnType = supplier.get();
            this.spawnTypeSupplier = spawnType == null ? SpawnTypes.PLUGIN : () -> spawnType;
            return this;
        }

        @Override
        protected void reset() {
            super.reset();
            this.stream = null;
            this.spawnTypeSupplier = null;
        }
    }
}

