/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.BlockEventTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.world.BlockChange;

class BlockEventTickPhaseState
extends TickPhaseState<BlockEventTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> FRAME_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        TrackableBlockEventDataBridge blockEventData = context.getSource(TrackableBlockEventDataBridge.class).orElse(null);
        if (blockEventData != null) {
            if (blockEventData.bridge$getTileEntity() != null) {
                frame.pushCause(blockEventData.bridge$getTileEntity());
            } else if (blockEventData.bridge$getTickingLocatable() != null) {
                frame.pushCause(blockEventData.bridge$getTickingLocatable());
                frame.addContext(EventContextKeys.BLOCK_EVENT_PROCESS, blockEventData.bridge$getTickingLocatable());
            }
        }
    });

    BlockEventTickPhaseState() {
    }

    @Override
    public BlockEventTickContext createNewContext(PhaseTracker tracker) {
        return new BlockEventTickContext(tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BlockEventTickContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    public void associateNeighborStateNotifier(BlockEventTickContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, ServerWorld minecraftWorld, PlayerTracker.Type notifier) {
        context.applyNotifierIfAvailable(user -> {
            LevelChunkBridge mixinChunk = (LevelChunkBridge)minecraftWorld.func_175726_f(notifyPos);
            mixinChunk.bridge$addTrackedBlockPosition(block, notifyPos, (UUID)user, PlayerTracker.Type.NOTIFIER);
        });
    }

    @Override
    public void postBlockTransactionApplication(BlockEventTickContext context, BlockChange blockChange, BlockTransactionReceipt receipt) {
        Block block = (Block)receipt.originalBlock().state().type();
        SpongeBlockSnapshot original = (SpongeBlockSnapshot)receipt.originalBlock();
        BlockPos changedBlockPos = original.getBlockPos();
        original.getServerWorld().ifPresent(worldServer -> {
            LevelChunkBridge changedMixinChunk = (LevelChunkBridge)worldServer.func_175726_f(changedBlockPos);
            changedMixinChunk.bridge$getBlockCreatorUUID(changedBlockPos).ifPresent(owner -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)owner, PlayerTracker.Type.CREATOR));
            changedMixinChunk.bridge$getBlockNotifierUUID(changedBlockPos).ifPresent(user -> changedMixinChunk.bridge$addTrackedBlockPosition(block, changedBlockPos, (UUID)user, PlayerTracker.Type.NOTIFIER));
        });
    }

    @Override
    public void unwind(BlockEventTickContext context) {
        TrackingUtil.processBlockCaptures(context);
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(BlockEventTickContext context, Entity entityToSpawn) {
        return SpawnTypes.CUSTOM;
    }
}

