/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.world.BlockChange;

class BlockTickPhaseState
extends LocationBasedTickPhaseState<BlockTickContext> {
    private final String desc;

    BlockTickPhaseState(String name) {
        this.desc = TrackingUtil.phaseStateToString("Tick", name, this);
    }

    @Override
    public BlockTickContext createNewContext(PhaseTracker tracker) {
        return new BlockTickContext(this, tracker);
    }

    @Override
    public boolean shouldProvideModifiers(BlockTickContext phaseContext) {
        return phaseContext.providesModifier;
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(BlockTickContext phaseContext, BlockState newState, BlockState currentState) {
        Block newBlock = newState.func_177230_c();
        if (phaseContext.tickingBlock instanceof IGrowable) {
            if (newBlock == Blocks.field_150350_a) {
                return BlockChange.BREAK;
            }
            if (newBlock instanceof IGrowable || newState.func_185904_a().func_76217_h()) {
                return BlockChange.GROW;
            }
        }
        return super.associateBlockChangeWithSnapshot(phaseContext, newState, currentState);
    }

    @Override
    public String toString() {
        return this.desc;
    }
}

