/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.transaction.BlockTransactionReceipt;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.common.accessor.world.entity.decoration.ItemFrameAccessor;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.bridge.world.entity.TrackableEntityBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState<EntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, EntityTickContext> ENTITY_TICK_MODIFIER = super.getFrameModifier().andThen((frame, context) -> {
        org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        ((TrackableEntityBridge)((Object)tickingEntity)).tracker$populateFrameInTickContext((CauseStackManager.StackFrame)frame, (EntityTickContext)context);
        frame.pushCause(tickingEntity);
    });

    EntityTickPhaseState() {
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, EntityTickContext> getFrameModifier() {
        return this.ENTITY_TICK_MODIFIER;
    }

    @Override
    public void unwind(EntityTickContext phaseContext) {
        org.spongepowered.api.entity.Entity tickingEntity = phaseContext.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        if (!TrackingUtil.processBlockCaptures(phaseContext)) {
            ((EntityBridge)((Object)tickingEntity)).bridge$onCancelledBlockChange(phaseContext);
        }
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(EntityTickContext context, Entity entityToSpawn) {
        if (entityToSpawn instanceof ExperienceOrb) {
            return SpawnTypes.EXPERIENCE;
        }
        if (entityToSpawn instanceof Projectile) {
            return SpawnTypes.PROJECTILE;
        }
        org.spongepowered.api.entity.Entity source = context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(() -> new IllegalStateException("Ticking over a non Entity"));
        if (source instanceof Ageable && source.getClass() == entityToSpawn.getClass()) {
            return SpawnTypes.BREEDING;
        }
        return super.getSpawnTypeForTransaction(context, entityToSpawn);
    }

    @Override
    public Supplier<ResourceKey> attemptWorldKey(EntityTickContext context) {
        Entity entity = context.getSource(Entity.class).orElseThrow(() -> new IllegalStateException("Expected to be ticking an entity, but we're not ticking an entity"));
        if (entity.field_70170_p.field_72995_K) {
            return () -> {
                throw new IllegalStateException("attempting a world key on the client???");
            };
        }
        return () -> (ResourceKey)entity.field_70170_p.func_234923_W_().func_240901_a_();
    }

    @Override
    protected EntityTickContext createNewContext(PhaseTracker tracker) {
        return new EntityTickContext(this, tracker);
    }

    @Override
    public void postBlockTransactionApplication(EntityTickContext context, BlockChange blockChange, BlockTransactionReceipt transaction) {
        if (blockChange == BlockChange.BREAK) {
            org.spongepowered.api.entity.Entity tickingEntity = context.getSource(org.spongepowered.api.entity.Entity.class).get();
            BlockPos blockPos = VecHelper.toBlockPos(transaction.originalBlock().position());
            List hangingEntities = ((ServerWorld)tickingEntity.world()).func_175647_a(HangingEntity.class, new AxisAlignedBB(blockPos, blockPos).func_72314_b(1.1, 1.1, 1.1), entityIn -> {
                if (entityIn == null) {
                    return false;
                }
                BlockPos entityPos = entityIn.func_174857_n();
                if (entityPos.equals((Object)blockPos.func_177982_a(0, 1, 0))) {
                    return true;
                }
                Direction entityFacing = entityIn.func_174811_aO();
                if (entityFacing == Direction.NORTH) {
                    return entityPos.equals((Object)blockPos.func_177971_a((Vector3i)Constants.Entity.HANGING_OFFSET_NORTH));
                }
                if (entityFacing == Direction.SOUTH) {
                    return entityIn.func_174857_n().equals((Object)blockPos.func_177971_a((Vector3i)Constants.Entity.HANGING_OFFSET_SOUTH));
                }
                if (entityFacing == Direction.WEST) {
                    return entityIn.func_174857_n().equals((Object)blockPos.func_177971_a((Vector3i)Constants.Entity.HANGING_OFFSET_WEST));
                }
                if (entityFacing == Direction.EAST) {
                    return entityIn.func_174857_n().equals((Object)blockPos.func_177971_a((Vector3i)Constants.Entity.HANGING_OFFSET_EAST));
                }
                return false;
            });
            for (HangingEntity entityHanging : hangingEntities) {
                if (!(entityHanging instanceof ItemFrameEntity)) continue;
                ItemFrameEntity itemFrame = (ItemFrameEntity)entityHanging;
                if (!itemFrame.field_70128_L) {
                    ((ItemFrameAccessor)itemFrame).invoker$dropItem((Entity)tickingEntity, true);
                }
                itemFrame.func_70106_y();
            }
        }
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, EntityTickContext context) {
        if (!context.applyNotifierIfAvailable(explosionContext::creator)) {
            context.applyOwnerIfAvailable(explosionContext::creator);
        }
        explosionContext.source(context.getSource(org.spongepowered.api.entity.Entity.class).orElseThrow(() -> new IllegalStateException("Ticking a non Entity")));
    }

    @Override
    public boolean doesBlockEventTracking(EntityTickContext context) {
        return context.allowsBlockEvents();
    }
}

