/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.bridge.world.level.TrackableBlockEventDataBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;

class TileEntityTickPhaseState
extends LocationBasedTickPhaseState<TileEntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, TileEntityTickContext> TILE_ENTITY_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(BlockEntity.class).ifPresent(frame::pushCause));

    TileEntityTickPhaseState() {
    }

    @Override
    public TileEntityTickContext createNewContext(PhaseTracker tracker) {
        return new TileEntityTickContext(this, tracker);
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, TileEntityTickContext> getFrameModifier() {
        return this.TILE_ENTITY_MODIFIER;
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(BlockEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).locatableBlock();
    }

    @Override
    public Supplier<SpawnType> getSpawnTypeForTransaction(TileEntityTickContext context, Entity entityToSpawn) {
        return context.requireSource(TileEntity.class) instanceof MobSpawnerTileEntity ? SpawnTypes.MOB_SPAWNER : SpawnTypes.BLOCK_SPAWNING;
    }

    @Override
    public void appendNotifierToBlockEvent(TileEntityTickContext context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackableBlockEventDataBridge blockEvent) {
        BlockEntity tickingTile = context.getSource(BlockEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        blockEvent.bridge$setTickingLocatable(tickingTile.locatableBlock());
        blockEvent.bridge$setTileEntity(tickingTile);
    }
}

