/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.fluid;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.fluid.FluidTypes;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.DataUtil;

public final class SpongeFluidStateBuilder
implements FluidState.Builder {
    private org.spongepowered.api.fluid.FluidState state = (org.spongepowered.api.fluid.FluidState)FluidTypes.EMPTY.get().defaultState();

    @Override
    public @NonNull FluidState.Builder fluid(@NonNull FluidType fluidType) {
        this.state = (org.spongepowered.api.fluid.FluidState)Objects.requireNonNull(fluidType).defaultState();
        return this;
    }

    @Override
    public @NonNull FluidState.Builder fromString(@NonNull String id) {
        this.state = this.parseString(id);
        return this;
    }

    @Override
    public <V> @NonNull FluidState.Builder add(@NonNull Key<@NonNull ? extends Value<V>> key, @NonNull V value) {
        Objects.requireNonNull(this.state, "The fluid type must be set first");
        Objects.requireNonNull(key, "The key must not be null");
        Objects.requireNonNull(key, "The value must not be null");
        this.state = this.state.with(key, value).orElse(this.state);
        return this;
    }

    @Override
    public @NonNull FluidState.Builder from(@NonNull org.spongepowered.api.fluid.FluidState holder) {
        this.state = holder;
        return this;
    }

    public @NonNull org.spongepowered.api.fluid.FluidState build() {
        Objects.requireNonNull(this.state, "There must be a FluidType specified.");
        return this.state;
    }

    @Override
    public @NonNull FluidState.Builder reset() {
        this.state = null;
        return this;
    }

    @Override
    public @NonNull Optional<org.spongepowered.api.fluid.FluidState> build(@NonNull DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Fluids.FLUID_STATE)) {
            return Optional.empty();
        }
        DataUtil.checkDataExists(container, Constants.Fluids.FLUID_STATE);
        try {
            return container.getString(Constants.Fluids.FLUID_STATE).map(this::parseString);
        }
        catch (Exception e) {
            throw new InvalidDataException("Could not retrieve a blockstate!", e);
        }
    }

    private org.spongepowered.api.fluid.FluidState parseString(String string) {
        StringReader reader = new StringReader(string);
        try {
            Fluid fluid = this.readFluid(reader);
            FluidState state = reader.canRead() && reader.peek() == '[' ? this.readProperties(reader, fluid) : fluid.func_207188_f();
            return (org.spongepowered.api.fluid.FluidState)state;
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("The string " + string + " doe not parse into a valid FluidState", e);
        }
    }

    private Fluid readFluid(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        ResourceLocation fluidKey = ResourceLocation.func_195826_a((StringReader)reader);
        return (Fluid)Registry.field_212619_h.func_241873_b(fluidKey).orElseThrow(() -> {
            reader.setCursor(cursor);
            return BlockStateParser.field_197259_a.createWithContext((ImmutableStringReader)reader, (Object)fluidKey.toString());
        });
    }

    private FluidState readProperties(StringReader reader, Fluid fluid) throws CommandSyntaxException {
        reader.skip();
        reader.skipWhitespace();
        FluidState state = fluid.func_207188_f();
        StateContainer stateContainer = fluid.func_207182_e();
        while (reader.canRead() && reader.peek() != ']') {
            reader.skipWhitespace();
            int cursor = reader.getCursor();
            String propertyKey = reader.readString();
            Property property = stateContainer.func_185920_a(propertyKey);
            if (property == null) {
                reader.setCursor(cursor);
                throw BlockStateParser.field_197260_b.createWithContext((ImmutableStringReader)reader, (Object)fluid.toString(), (Object)propertyKey);
            }
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() == '=') {
                reader.skip();
                reader.skipWhitespace();
                int cursor1 = reader.getCursor();
                state = this.parseValue(state, reader, property, cursor1);
                reader.skipWhitespace();
                if (!reader.canRead()) continue;
                if (reader.peek() == ',') {
                    reader.skip();
                    continue;
                }
                if (reader.peek() == ']') break;
                throw BlockStateParser.field_197264_f.createWithContext((ImmutableStringReader)reader);
            }
            throw BlockStateParser.field_197263_e.createWithContext((ImmutableStringReader)reader, (Object)fluid.toString(), (Object)propertyKey);
        }
        if (!reader.canRead()) {
            throw BlockStateParser.field_197264_f.createWithContext((ImmutableStringReader)reader);
        }
        reader.skip();
        return state;
    }

    private <T extends Comparable<T>> FluidState parseValue(FluidState state, StringReader reader, Property<T> property, int cursor) throws CommandSyntaxException {
        Optional propertyValue = property.func_185929_b(reader.readString());
        if (propertyValue.isPresent()) {
            return (FluidState)state.func_206870_a(property, (Comparable)propertyValue.get());
        }
        reader.setCursor(cursor);
        throw BlockStateParser.field_197262_d.createWithContext((ImmutableStringReader)reader, (Object)state.func_206886_c().toString(), (Object)property.func_177701_a(), (Object)cursor);
    }
}

