/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.common.bridge.world.inventory.CarriedBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.plugin.PluginContainer;

public class CustomInventory
implements IInventory,
CarriedBridge {
    private SlotLensProvider slotLensProvider;
    private Lens lens;
    private final PluginContainer plugin;
    private final @Nullable UUID identity;
    private final List<Inventory> inventories;
    private int size;
    private Carrier carrier;

    public CustomInventory(PluginContainer plugin, int size, Lens lens, SlotLensProvider provider, List<Inventory> inventories, @Nullable UUID identity, @Nullable Carrier carrier) {
        this.plugin = plugin;
        this.size = size;
        this.identity = identity;
        this.carrier = carrier;
        this.lens = lens;
        this.slotLensProvider = provider;
        this.inventories = inventories;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    @Override
    public Optional<Carrier> bridge$getCarrier() {
        return Optional.ofNullable(this.carrier);
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }

    public @Nullable UUID getIdentity() {
        return this.identity;
    }

    public int func_70302_i_() {
        return this.size;
    }

    public boolean func_191420_l() {
        for (Inventory inv : this.inventories) {
            if (inv.totalQuantity() <= 0) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() > index - offset) {
                return inv.slot(index - offset).map(InventoryAdapter.class::cast).map(slot -> slot.inventoryAdapter$getRootLens().getStack(slot.inventoryAdapter$getFabric(), 0)).orElse(ItemStack.field_190927_a);
            }
            offset += inv.capacity();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() <= index - offset) {
                offset += inv.capacity();
                continue;
            }
            InventoryTransactionResult.Poll result = inv.pollFrom(index - offset, count);
            return ItemStackUtil.fromSnapshotToNative(result.polledItem());
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() > index - offset) {
                InventoryTransactionResult.Poll result = inv.pollFrom(index - offset);
                return ItemStackUtil.fromSnapshotToNative(result.polledItem());
            }
            offset += inv.capacity();
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        int offset = 0;
        for (Inventory inv : this.inventories) {
            if (inv.capacity() > index - offset) {
                inv.set(index - offset, ItemStackUtil.fromNative(stack));
                return;
            }
            offset += inv.capacity();
        }
    }

    public void func_70296_d() {
        for (Inventory inventory : this.inventories) {
            if (!(inventory instanceof IInventory)) continue;
            ((IInventory)inventory).func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        for (Inventory inventory : this.inventories) {
            inventory.clear();
        }
    }
}

