/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.custom.CustomContainer;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.custom.SpongeViewableInventoryBuilder;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.plugin.PluginContainer;

public class ViewableCustomInventory
extends CustomInventory
implements INamedContainerProvider {
    private final ContainerType type;
    private final SpongeViewableInventoryBuilder.ContainerTypeInfo info;
    private boolean vanilla = false;
    private final Set<PlayerEntity> viewers = new HashSet<PlayerEntity>();
    private final IntArray data;

    public ViewableCustomInventory(PluginContainer plugin, ContainerType type, SpongeViewableInventoryBuilder.ContainerTypeInfo info, int size, Lens lens, SlotLensProvider provider, List<Inventory> inventories, @Nullable UUID identity, @Nullable Carrier carrier) {
        super(plugin, size, lens, provider, inventories, identity, carrier);
        this.type = type;
        this.info = info;
        this.data = this.info.dataProvider.get();
    }

    public ViewableCustomInventory vanilla() {
        this.vanilla = true;
        return this;
    }

    public ContainerType getType() {
        return this.type;
    }

    public void func_174889_b(PlayerEntity player) {
        this.viewers.add(player);
    }

    public void func_174886_c(PlayerEntity player) {
        this.viewers.remove(player);
    }

    public @Nullable Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        if (this.vanilla) {
            return this.info.containerProvider.createMenu(id, playerInv, player, this);
        }
        return new CustomContainer(id, player, this, this.type);
    }

    public IntArray getData() {
        return this.data;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("ViewableCustomInventory");
    }
}

