/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.property.KeyValuePair;

public abstract class AbstractLens
implements Lens {
    protected Class<? extends Inventory> adapterType;
    protected final int base;
    private Lens parent;
    protected List<Lens> spanningChildren = new ArrayList<Lens>();
    protected List<Lens> children = new ArrayList<Lens>();
    protected Map<Lens, Map<Key<?>, Object>> handleMap = new LinkedHashMap();
    protected int size;
    private int maxOrdinal = 0;
    private List<SlotLens> slotCache;
    public static final int LIMIT = 2;

    public AbstractLens(int base, int size) {
        Preconditions.checkArgument((base >= 0 ? 1 : 0) != 0, (String)"Invalid offset: %s", (int)base);
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s", (int)size);
        this.base = base;
        this.size = size;
    }

    public AbstractLens(int base, int size, Class<? extends Inventory> adapterType) {
        Preconditions.checkArgument((base >= 0 ? 1 : 0) != 0, (String)"Invalid offset: %s", (int)base);
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s", (int)size);
        Preconditions.checkNotNull(adapterType, (Object)"adapterType");
        this.base = base;
        this.size = size;
        this.adapterType = adapterType;
    }

    protected void addChild(Lens lens, KeyValuePair ... keyValuePairs) {
        Preconditions.checkNotNull((Object)lens, (Object)"Attempted to register a null lens");
        if (!this.children.contains(lens)) {
            this.children.add(lens);
        }
        this.addKeyValuePairs(lens, keyValuePairs);
    }

    protected void addSpanningChild(Lens lens, KeyValuePair ... keyValuePairs) {
        this.addChild(lens, keyValuePairs);
        this.spanningChildren.add(lens);
        this.maxOrdinal += lens.slotCount();
        this.addKeyValuePairs(lens, keyValuePairs);
    }

    private void addKeyValuePairs(Lens lens, KeyValuePair[] keyValuePairs) {
        Map map = this.handleMap.computeIfAbsent(lens, l -> new HashMap());
        for (KeyValuePair pair : keyValuePairs) {
            map.put(pair.getKey(), pair.getValue());
        }
    }

    protected void setParent(Lens parent) {
        this.parent = parent;
    }

    @Override
    public Lens getParent() {
        return this.parent;
    }

    @Override
    public Class<? extends Inventory> getAdapterType() {
        return this.adapterType;
    }

    @Override
    public @Nullable SlotLens getSlotLens(Fabric fabric, int ordinal) {
        if (ordinal < 0 || ordinal > this.maxOrdinal) {
            return null;
        }
        int offset = 0;
        for (Lens child : this.spanningChildren) {
            int count = child.slotCount();
            if (ordinal < offset + count) {
                return child.getSlotLens(fabric, ordinal - offset);
            }
            offset += count;
        }
        return null;
    }

    @Override
    public List<SlotLens> getSlots(Fabric fabric) {
        if (this.slotCache == null) {
            this.slotCache = new ArrayList<SlotLens>();
            if (this instanceof SlotLens) {
                this.slotCache.add((SlotLens)((Object)this));
            } else {
                for (Lens child : this.getSpanningChildren()) {
                    if (child instanceof SlotLens) {
                        this.slotCache.add((SlotLens)child);
                        continue;
                    }
                    this.slotCache.addAll(child.getSlots(fabric));
                }
            }
        }
        return this.slotCache;
    }

    @Override
    public List<Lens> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<Lens> getSpanningChildren() {
        return this.spanningChildren;
    }

    @Override
    public int slotCount() {
        return this.size;
    }

    @Override
    public Lens getLens(int index) {
        return this.children.get(index);
    }

    @Override
    public Map<Key<?>, Object> getDataFor(Lens child) {
        if (!this.has(child)) {
            HashMap dataMap = new HashMap();
            for (Lens spanningChild : this.spanningChildren) {
                if (spanningChild instanceof SlotLens) continue;
                try {
                    dataMap.putAll(spanningChild.getDataFor(child));
                }
                catch (Exception exception) {}
            }
            return dataMap;
        }
        return this.handleMap.get(child);
    }

    protected void addMissingSpanningSlots(int base, SlotLensProvider slots) {
        int additionalSlots = this.size - base;
        if (additionalSlots > 0) {
            this.addSpanningChild(new DefaultIndexedLens(base, additionalSlots, slots), new KeyValuePair[0]);
        }
    }

    @Override
    public boolean has(Lens lens) {
        return this.children.contains(lens);
    }

    @Override
    public boolean isSubsetOf(Collection<Lens> c) {
        return c.containsAll(this.children);
    }

    @Override
    public List<Lens> children() {
        return this.children;
    }

    @Override
    public int getMaxStackSize(Fabric fabric) {
        return fabric.fabric$getMaxStackSize();
    }

    @Override
    public int base() {
        return this.base;
    }

    @Override
    public String toString(int deep) {
        String result = this.ident(deep) + this.getClass().getSimpleName() + ": (" + this.size + ") base:" + this.base + "\n";
        if (!this.children.isEmpty() && deep < 2) {
            result = result + this.ident(deep) + "Children: ";
            for (Lens child : this.children) {
                if (this.spanningChildren.contains(child)) {
                    result = result + "\n" + this.ident(deep) + "(Spanning)";
                }
                result = result + child.toString(deep + 1);
            }
        }
        return result;
    }

    private String ident(int deep) {
        String ident = "";
        for (int i = 0; i < deep; ++i) {
            ident = ident + "-";
        }
        return ident;
    }

    public String toString() {
        return this.toString(0);
    }
}

