/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl.comp;

import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.common.accessor.world.inventory.CraftingMenuAccessor;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.impl.comp.GridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class CraftingGridInventoryLens
extends AbstractLens {
    private GridInventoryLens grid;

    public CraftingGridInventoryLens(int base, int width, int height, SlotLensProvider slots) {
        super(base, width * height, CraftingGridInventory.class);
        this.init(slots, width, height);
    }

    private void init(SlotLensProvider slots, int width, int height) {
        int ord = 0;
        int slot = this.base;
        while (ord < this.size) {
            this.addChild(slots.getSlotLens(slot), KeyValuePair.slotIndex(ord));
            ++ord;
            ++slot;
        }
        this.grid = new GridInventoryLens(this.base, width, height, slots);
        this.addSpanningChild(this.grid, new KeyValuePair[0]);
    }

    public GridInventoryLens getGrid() {
        return this.grid;
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        if (fabric instanceof CraftingGridInventory) {
            return (CraftingGridInventory)((Object)fabric);
        }
        if (fabric instanceof PlayerContainer) {
            return (CraftingGridInventory)((PlayerContainer)fabric).func_234641_j_();
        }
        if (fabric instanceof WorkbenchContainer) {
            return (CraftingGridInventory)((CraftingMenuAccessor)((Object)fabric)).accessor$craftSlots();
        }
        throw new IllegalStateException(fabric.getClass().getName() + " is not a known CraftingGridInventory.");
    }
}

