/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.util;

import java.util.Optional;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.carrier.chest.Chest;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.inventory.InventoryBridge;
import org.spongepowered.common.bridge.world.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.entity.player.SpongeUserData;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.custom.CarriedWrapperInventory;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static CraftingGridInventory toSpongeInventory(CraftingInventory inv) {
        return (CraftingGridInventory)inv;
    }

    public static <C extends IInventory> C toNativeInventory(Inventory inv) {
        if (inv instanceof CraftingInventory) {
            return (C)((IInventory)inv);
        }
        if (inv instanceof Container) {
            for (InventoryBridge inventory : ((InventoryAdapter)((Object)inv)).inventoryAdapter$getFabric().fabric$allInventories()) {
                if (!(inventory instanceof CraftingInventory)) continue;
                return (C)((IInventory)inventory);
            }
        }
        throw new IllegalStateException("Invalid CraftingGridInventory. Could not find CraftingInventory.\nInventory was: " + inv.getClass().getSimpleName());
    }

    public static Optional<Inventory> getDoubleChestInventory(ChestTileEntity chest) {
        Optional<Chest> connectedChestOptional = ((Chest)chest).connectedChest();
        if (!connectedChestOptional.isPresent()) {
            return Optional.empty();
        }
        ChestType chestType = (ChestType)chest.func_195044_w().func_177229_b((Property)ChestBlock.field_196314_b);
        ChestTileEntity connectedChest = (ChestTileEntity)connectedChestOptional.get();
        if (chestType == ChestType.RIGHT) {
            return Optional.of((Inventory)new DoubleSidedInventory((IInventory)chest, (IInventory)connectedChest));
        }
        return Optional.of((Inventory)new DoubleSidedInventory((IInventory)connectedChest, (IInventory)chest));
    }

    public static Inventory toInventory(IInventory inventory) {
        return InventoryUtil.toInventory(inventory, null);
    }

    public static Inventory toInventory(Object inventory, @Nullable Object forgeItemHandler) {
        if (forgeItemHandler == null) {
            if (inventory instanceof ChestTileEntity) {
                inventory = InventoryUtil.getDoubleChestInventory((ChestTileEntity)inventory).orElse((Inventory)inventory);
            }
            if (inventory instanceof Inventory) {
                return (Inventory)inventory;
            }
        }
        if (forgeItemHandler instanceof Inventory) {
            return (Inventory)forgeItemHandler;
        }
        return PlatformHooks.INSTANCE.getInventoryHooks().toInventory(inventory, forgeItemHandler);
    }

    public static InventoryAdapter findAdapter(Object inventory) {
        if (inventory instanceof InventoryAdapter) {
            return (InventoryAdapter)inventory;
        }
        if (inventory instanceof Fabric) {
            return new BasicInventoryAdapter((Fabric)inventory, null, null);
        }
        return PlatformHooks.INSTANCE.getInventoryHooks().findInventoryAdapter(inventory);
    }

    public static TrackedInventoryBridge forCapture(Object toCapture) {
        if (toCapture instanceof TrackedInventoryBridge) {
            return (TrackedInventoryBridge)toCapture;
        }
        return null;
    }

    public static PluginContainer getPluginContainer(Object inventory) {
        PluginContainer container;
        Object base;
        Optional carrier;
        if (inventory instanceof CustomInventory) {
            return ((CustomInventory)inventory).getPlugin();
        }
        if (inventory instanceof CarriedInventory && (carrier = ((CarriedInventory)inventory).carrier()).isPresent()) {
            inventory = carrier.get();
        }
        if ((base = inventory) instanceof BlockEntity) {
            ResourceKey key = Sponge.game().registry(RegistryTypes.BLOCK_ENTITY_TYPE).valueKey(((BlockEntity)base).type());
            String pluginId = key.namespace();
            container = Sponge.pluginManager().plugin(pluginId).orElseThrow(() -> new AssertionError((Object)("Missing plugin " + pluginId + " for block " + key.namespace() + ":" + key.value())));
        } else if (base instanceof Entity) {
            ResourceKey key = (ResourceKey)EntityType.func_200718_a((EntityType)((EntityType)((Entity)base).type()));
            String pluginId = key.namespace();
            container = Sponge.pluginManager().plugin(pluginId).orElseGet(() -> {
                SpongeCommon.logger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.instance()).minecraftPlugin();
            });
        } else {
            container = base instanceof SpongeUserData ? ((Launch)Launch.instance()).minecraftPlugin() : Sponge.pluginManager().plugin(PlatformHooks.INSTANCE.getInventoryHooks().getModIdFromInventory(base.getClass())).orElseGet(() -> {
                SpongeCommon.logger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.instance()).minecraftPlugin();
            });
        }
        return container;
    }

    public static <T extends Carrier> CarriedInventory<T> carriedWrapperInventory(IInventory inventory, T carrier) {
        return (CarriedInventory)((Object)new CarriedWrapperInventory(inventory, carrier));
    }
}

