/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;

public final class SpongeItemStack {

    public static final class FactoryImpl
    implements ItemStack.Factory {
        @Override
        public ItemStack empty() {
            return (ItemStack)net.minecraft.item.ItemStack.field_190927_a;
        }
    }

    public static final class BuilderImpl
    extends AbstractDataBuilder<ItemStack>
    implements ItemStack.Builder {
        private ItemType type;
        private int quantity;
        private @Nullable LinkedHashMap<Key<?>, Object> keyValues;
        private @Nullable CompoundNBT compound;

        public BuilderImpl() {
            super(ItemStack.class, 1);
            this.reset();
        }

        @Override
        public ItemStack.Builder itemType(ItemType itemType) {
            Preconditions.checkNotNull((Object)itemType, (Object)"Item type cannot be null");
            this.type = itemType;
            return this;
        }

        @Override
        public ItemType currentItem() {
            return this.type == null ? BlockTypes.AIR.get().item().get() : this.type;
        }

        @Override
        public ItemStack.Builder quantity(int quantity) throws IllegalArgumentException {
            Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0, (Object)"Quantity must not be smaller than 0");
            this.quantity = quantity;
            return this;
        }

        @Override
        public <V> ItemStack.Builder add(Key<? extends Value<V>> key, V value) throws IllegalArgumentException {
            if (this.keyValues == null) {
                this.keyValues = new LinkedHashMap();
            }
            this.keyValues.put((Key)Preconditions.checkNotNull(key, (Object)"Key cannot be null!"), Preconditions.checkNotNull(value, (Object)"Value cannot be null!"));
            return this;
        }

        @Override
        public ItemStack.Builder fromItemStack(ItemStack itemStack) {
            Preconditions.checkNotNull((Object)itemStack, (Object)"Item stack cannot be null");
            this.type = itemStack.type();
            this.quantity = itemStack.quantity();
            if (itemStack instanceof net.minecraft.item.ItemStack) {
                CompoundNBT itemCompound = ((net.minecraft.item.ItemStack)itemStack).func_77978_p();
                this.compound = itemCompound != null && !itemCompound.isEmpty() ? itemCompound.func_74737_b() : null;
            }
            return this;
        }

        @Override
        public ItemStack.Builder attributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
            CompoundNBT compound;
            Preconditions.checkNotNull((Object)attributeType, (Object)"AttributeType cannot be null");
            Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
            Preconditions.checkNotNull((Object)equipmentType, (Object)"EquipmentType cannot be null");
            if (this.compound == null) {
                this.compound = new CompoundNBT();
            }
            if (!(compound = this.compound).func_150297_b("AttributeModifiers", 9)) {
                compound.func_218657_a("AttributeModifiers", (INBT)new ListNBT());
            }
            ListNBT attributeModifiers = compound.func_150295_c("AttributeModifiers", 10);
            return this;
        }

        private void writeAttributeModifier(ListNBT attributeModifiers, net.minecraft.entity.ai.attributes.AttributeModifier attributeModifier, EquipmentSlotType slot) {
            CompoundNBT modifierNbt = attributeModifier.func_233801_e_();
            modifierNbt.func_74778_a("AttributeName", attributeModifier.func_111166_b());
            if (slot != null) {
                modifierNbt.func_74778_a("Slot", slot.func_188450_d());
            }
            attributeModifiers.add((Object)modifierNbt);
        }

        @Override
        public ItemStack.Builder fromContainer(DataView container) {
            Preconditions.checkNotNull((Object)container);
            if (!container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
                return this;
            }
            this.reset();
            int count = container.getInt(Constants.ItemStack.COUNT).get();
            this.quantity(count);
            ItemType itemType = container.getRegistryValue(Constants.ItemStack.TYPE, RegistryTypes.ITEM_TYPE, SpongeCommon.game()).get();
            this.itemType(itemType);
            if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
                CompoundNBT compound = NBTTranslator.INSTANCE.translate(container.getView(Constants.Sponge.UNSAFE_NBT).get());
                if (compound.func_150297_b("SpongeData", 10)) {
                    compound.func_82580_o("SpongeData");
                }
                this.compound = !compound.isEmpty() ? compound : null;
            }
            if (container.contains(Constants.Sponge.DATA_MANIPULATORS)) {
                List<DataView> list = container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get();
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromSnapshot(ItemStackSnapshot snapshot) {
            Preconditions.checkNotNull((Object)snapshot, (Object)"The snapshot was null!");
            this.itemType(snapshot.type());
            this.quantity(snapshot.quantity());
            for (Value.Immutable value : snapshot.getValues()) {
                this.add(value);
            }
            if (snapshot instanceof SpongeItemStackSnapshot) {
                this.compound = ((SpongeItemStackSnapshot)snapshot).getCompound().orElse(null);
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromBlockSnapshot(BlockSnapshot blockSnapshot) {
            Optional<CompoundNBT> compound;
            Preconditions.checkNotNull((Object)blockSnapshot, (Object)"The snapshot was null!");
            this.reset();
            BlockType blockType = blockSnapshot.state().type();
            ResourceLocation blockTypeKey = Registry.field_212618_g.func_177774_c((Object)((Block)blockType));
            Optional<ItemType> itemType = blockType.item();
            this.itemType(itemType.orElseThrow(() -> new IllegalArgumentException("ItemType not found for block type: " + blockTypeKey)));
            this.quantity(1);
            if (blockSnapshot instanceof SpongeBlockSnapshot && (compound = ((SpongeBlockSnapshot)blockSnapshot).getCompound()).isPresent()) {
                this.compound = new CompoundNBT();
                this.compound.func_218657_a("BlockEntityTag", (INBT)compound.get());
            }
            return this;
        }

        @Override
        public ItemStack.Builder fromBlockState(BlockState blockState) {
            Objects.requireNonNull(blockState, "blockState");
            BlockType blockType = blockState.type();
            ResourceLocation blockTypeKey = Registry.field_212618_g.func_177774_c((Object)((Block)blockType));
            this.itemType(blockType.item().orElseThrow(() -> new IllegalArgumentException("Missing valid ItemType for BlockType: " + blockTypeKey)));
            blockState.getValues().forEach(this::add);
            return this;
        }

        @Override
        public ItemStack.Builder from(ItemStack value) {
            return this.fromItemStack(value);
        }

        @Override
        protected Optional<ItemStack> buildContent(DataView container) throws InvalidDataException {
            CompoundNBT compound;
            Preconditions.checkNotNull((Object)container);
            if (!container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
                return Optional.empty();
            }
            int count = container.getInt(Constants.ItemStack.COUNT).get();
            ItemType itemType = container.getRegistryValue(Constants.ItemStack.TYPE, RegistryTypes.ITEM_TYPE, SpongeCommon.game()).orElseThrow(() -> new IllegalStateException("Unable to find item with id: "));
            net.minecraft.item.ItemStack itemStack = new net.minecraft.item.ItemStack((IItemProvider)((Item)itemType), count);
            if (container.contains(Constants.Sponge.UNSAFE_NBT) && !(compound = NBTTranslator.INSTANCE.translate(container.getView(Constants.Sponge.UNSAFE_NBT).get())).isEmpty()) {
                BuilderImpl.fixEnchantmentData(itemType, compound);
                itemStack.func_77982_d(compound);
            }
            if (container.contains(Constants.Sponge.DATA_MANIPULATORS)) {
                List<DataView> list = container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get();
            }
            return Optional.of((ItemStack)itemStack);
        }

        @Override
        public ItemStack.Builder reset() {
            this.type = null;
            this.quantity = 1;
            this.compound = null;
            return this;
        }

        @Override
        public ItemStack build() throws IllegalStateException {
            CompoundNBT compoundTag;
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Item type has not been set");
            if (this.type == null || this.quantity <= 0) {
                return (ItemStack)net.minecraft.item.ItemStack.field_190927_a;
            }
            ItemStack stack = (ItemStack)new net.minecraft.item.ItemStack((IItemProvider)((Item)this.type), this.quantity);
            if (this.compound != null && !this.compound.isEmpty()) {
                ((net.minecraft.item.ItemStack)stack).func_77982_d(this.compound.func_74737_b());
            }
            if (this.keyValues != null) {
                this.keyValues.forEach((key, value) -> stack.offer(key, value));
            }
            if (this.compound != null && this.compound.func_150297_b("ForgeCaps", 10) && (compoundTag = this.compound.func_74775_l("ForgeCaps")) != null) {
                PlatformHooks.INSTANCE.getItemHooks().setCapabilitiesFromSpongeBuilder((net.minecraft.item.ItemStack)stack, compoundTag);
            }
            return stack;
        }

        public static void fixEnchantmentData(ItemType itemType, CompoundNBT compound) {
            ListNBT nbttaglist = itemType == Items.field_151134_bR ? compound.func_150295_c("StoredEnchantments", 10) : compound.func_150295_c("Enchantments", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
                short id = nbttagcompound.func_74765_d("id");
                short lvl = nbttagcompound.func_74765_d("lvl");
                nbttagcompound.func_74777_a("id", id);
                nbttagcompound.func_74777_a("lvl", lvl);
            }
        }
    }
}

