/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.datapack.DataPackType;
import org.spongepowered.api.datapack.DataPackTypes;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public abstract class SpongeRecipeRegistration
implements RecipeRegistration,
IFinishedRecipe {
    protected final ResourceLocation key;
    protected final IRecipeSerializer<?> serializer;
    protected final ResourceLocation advancementId;
    protected final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    protected final String group;

    public static <S extends IRecipeSerializer<T>, T extends IRecipe<?>> S register(String spongeName, S recipeSerializer) {
        return (S)((IRecipeSerializer)Registry.func_218325_a((Registry)Registry.field_218368_I, (String)new ResourceLocation("sponge", spongeName).toString(), recipeSerializer));
    }

    public static <S extends IRecipeSerializer<T>, T extends IRecipe<?>> S register(ResourceLocation resourceLocation, S recipeSerializer) {
        return (S)((IRecipeSerializer)Registry.func_218325_a((Registry)Registry.field_218368_I, (String)resourceLocation.toString(), recipeSerializer));
    }

    public SpongeRecipeRegistration(ResourceLocation key, IRecipeSerializer<?> serializer, Item resultItem, String group) {
        this.key = key;
        this.serializer = serializer;
        ItemGroup itemGroup = resultItem.func_77640_w();
        this.advancementId = new ResourceLocation(key.func_110624_b(), "recipes/" + (itemGroup == null ? "uncategorized" : itemGroup.func_200300_c()) + "/" + key.func_110623_a());
        this.advancementBuilder.func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)key)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)key));
        this.group = group == null ? "" : group;
    }

    public static <C extends IInventory> IRecipeSerializer<?> determineSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction, Map<Character, Ingredient> ingredients, IRecipeSerializer<?> vanilla, IRecipeSerializer<?> sponge) {
        return SpongeRecipeRegistration.determineSerializer(resultStack, resultFunction, remainingItemsFunction, ingredients.values(), vanilla, sponge);
    }

    public static <C extends IInventory> IRecipeSerializer<?> determineSerializer(ItemStack resultStack, Function<C, ItemStack> resultFunction, Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction, Collection<Ingredient> ingredients, IRecipeSerializer<?> vanilla, IRecipeSerializer<?> sponge) {
        if (resultStack.func_77942_o() || resultFunction != null || remainingItemsFunction != null) {
            return sponge;
        }
        for (Ingredient value : ingredients) {
            if (!(value instanceof SpongeIngredient)) continue;
            return sponge;
        }
        return vanilla;
    }

    public ResourceLocation func_200442_b() {
        return this.key;
    }

    @Override
    public ResourceKey key() {
        return (ResourceKey)this.key;
    }

    public IRecipeSerializer<?> func_218609_c() {
        return this.serializer;
    }

    public void func_218610_a(JsonObject json) {
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        this.serializeShape(json);
        this.serializeResult(json);
        this.serializeAdditional(json);
    }

    public abstract void serializeShape(JsonObject var1);

    public abstract void serializeResult(JsonObject var1);

    public void serializeAdditional(JsonObject json) {
    }

    public JsonObject func_200440_c() {
        return this.advancementBuilder.func_200273_b();
    }

    public ResourceLocation func_200443_d() {
        return this.advancementId;
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        try {
            return DataFormats.JSON.get().read(this.func_200441_a().toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public DataPackType type() {
        return DataPackTypes.RECIPE;
    }
}

