/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeCookingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Ingredient ingredient;
    private final Item result;
    private final float experience;
    private final Ticks cookingTime;
    private final ItemStack spongeResult;
    private final Function<IInventory, ItemStack> resultFunction;

    public SpongeCookingRecipeRegistration(ResourceLocation key, IRecipeSerializer<?> serializer, String group, Ingredient ingredient, float experience, Ticks cookingTime, ItemStack spongeResult, Function<IInventory, ItemStack> resultFunction) {
        super(key, serializer, spongeResult.func_77973_b(), group);
        this.ingredient = ingredient;
        this.result = spongeResult.func_77973_b();
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.spongeResult = spongeResult.func_77942_o() ? spongeResult : null;
        this.resultFunction = resultFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        json.add("ingredient", this.ingredient.func_200304_c());
    }

    @Override
    public void serializeResult(JsonObject json) {
        json.addProperty("result", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
        if (this.spongeResult != null) {
            this.spongeResult.func_190920_e(1);
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.func_200442_b(), this.resultFunction));
        }
    }

    @Override
    public void serializeAdditional(JsonObject json) {
        json.addProperty("experience", Float.valueOf(this.experience));
        json.addProperty("cookingtime", this.cookingTime.ticks());
    }
}

