/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.BlastingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.cooking.SpongeBlastingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCampfireCookingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeFurnaceRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmokingRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;

public abstract class SpongeCookingRecipeSerializer<R extends AbstractCookingRecipe>
implements IRecipeSerializer<R> {
    private final int defaultCookingTime;

    public SpongeCookingRecipeSerializer(int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
    }

    public R fromJson(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonElement jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = IngredientUtil.spongeDeserialize(jsonelement);
        String result = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
        ResourceLocation resourcelocation = new ResourceLocation(result);
        ItemStack itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
        ItemStack spongeStack = IngredientResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        Function<IInventory, ItemStack> resultFunction = IngredientResultUtil.deserializeResultFunction(json);
        float exp = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int cookTime = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.create(recipeId, group, ingredient, spongeStack == null ? itemstack : spongeStack, exp, cookTime, resultFunction);
    }

    protected abstract R create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6, Function<IInventory, ItemStack> var7);

    public R fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void toNetwork(PacketBuffer buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public static class Campfire
    extends SpongeCookingRecipeSerializer<CampfireCookingRecipe> {
        public static final SpongeCookingRecipeSerializer<CampfireCookingRecipe> SPONGE_CAMPFIRE_COOKING = SpongeRecipeRegistration.register("campfire_cooking", new Campfire());

        public Campfire() {
            super(100);
        }

        @Override
        protected CampfireCookingRecipe create(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<IInventory, ItemStack> resultFunction) {
            return new SpongeCampfireCookingRecipe(id, group, ingredient, result, experience, cookingTime, resultFunction);
        }
    }

    public static class Smoking
    extends SpongeCookingRecipeSerializer<SmokingRecipe> {
        public static final SpongeCookingRecipeSerializer<SmokingRecipe> SPONGE_SMOKING = SpongeRecipeRegistration.register("smoking", new Smoking());

        public Smoking() {
            super(100);
        }

        @Override
        protected SmokingRecipe create(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<IInventory, ItemStack> resultFunction) {
            return new SpongeSmokingRecipe(id, group, ingredient, result, experience, cookingTime, resultFunction);
        }
    }

    public static class Blasting
    extends SpongeCookingRecipeSerializer<BlastingRecipe> {
        public static final SpongeCookingRecipeSerializer<BlastingRecipe> SPONGE_BLASTING = SpongeRecipeRegistration.register("blasting", new Blasting());

        public Blasting() {
            super(100);
        }

        @Override
        protected BlastingRecipe create(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<IInventory, ItemStack> resultFunction) {
            return new SpongeBlastingRecipe(id, group, ingredient, result, experience, cookingTime, resultFunction);
        }
    }

    public static class Smelting
    extends SpongeCookingRecipeSerializer<FurnaceRecipe> {
        public static final SpongeCookingRecipeSerializer<FurnaceRecipe> SPONGE_SMELTING = SpongeRecipeRegistration.register("smelting", new Smelting());

        public Smelting() {
            super(200);
        }

        @Override
        protected FurnaceRecipe create(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, float experience, int cookingTime, Function<IInventory, ItemStack> resultFunction) {
            return new SpongeFurnaceRecipe(id, group, ingredient, result, experience, cookingTime, resultFunction);
        }
    }
}

