/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.custom;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.MissingImplementationException;

public final class SpongeSpecialRecipe
extends SpecialRecipe {
    private final BiPredicate<CraftingGridInventory, ServerWorld> biPredicate;
    private final Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction;
    private final Function<CraftingGridInventory, ItemStack> resultFunction;

    public SpongeSpecialRecipe(ResourceLocation idIn, BiPredicate<CraftingGridInventory, ServerWorld> biPredicate, Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction, Function<CraftingGridInventory, ItemStack> resultFunction) {
        super(idIn);
        this.biPredicate = biPredicate;
        this.remainingItemsFunction = remainingItemsFunction;
        this.resultFunction = resultFunction;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.biPredicate.test(InventoryUtil.toSpongeInventory(inv), (ServerWorld)worldIn);
    }

    public net.minecraft.item.ItemStack assemble(CraftingInventory inv) {
        return ItemStackUtil.toNative(this.resultFunction.apply(InventoryUtil.toSpongeInventory(inv)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_194133_a(int width, int height) {
        throw new MissingImplementationException("SpongeSpecialRecipe", "canFit");
    }

    public NonNullList<net.minecraft.item.ItemStack> getRemainingItems(CraftingInventory inv) {
        if (this.remainingItemsFunction == null) {
            return super.func_179532_b((IInventory)inv);
        }
        List<ItemStack> remainingSponge = this.remainingItemsFunction.apply(InventoryUtil.toSpongeInventory(inv));
        NonNullList remaining = NonNullList.func_191196_a();
        remainingSponge.forEach(item -> remaining.add((Object)ItemStackUtil.toNative(item)));
        return remaining;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return IRecipeSerializer.field_222167_k;
    }
}

