/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shaped;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeShapedCraftingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Item result;
    private final int count;
    private final List<String> pattern;
    private final Map<Character, Ingredient> ingredientMap;
    private final ItemStack spongeResult;
    private final Function<CraftingInventory, ItemStack> resultFunction;
    private final Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction;

    public SpongeShapedCraftingRecipeRegistration(ResourceLocation key, IRecipeSerializer<?> serializer, String group, List<String> pattern, Map<Character, Ingredient> ingredients, ItemStack spongeResult, Function<CraftingInventory, ItemStack> resultFunction, Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction) {
        super(key, serializer, spongeResult.func_77973_b(), group);
        this.result = spongeResult.func_77973_b();
        this.count = spongeResult.func_190916_E();
        this.pattern = pattern;
        this.ingredientMap = ingredients;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
        this.remainingItemsFunction = remainingItemsFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        JsonArray jsonarray = new JsonArray();
        this.pattern.forEach(jsonarray::add);
        json.add("pattern", jsonarray);
        JsonObject jsonobject = new JsonObject();
        this.ingredientMap.forEach((key, value) -> jsonobject.add(String.valueOf(key), value.func_200304_c()));
        json.add("key", jsonobject);
    }

    @Override
    public void serializeResult(JsonObject json) {
        JsonObject result = new JsonObject();
        result.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
        if (this.count > 1) {
            result.addProperty("count", this.count);
        }
        json.add("result", result);
        if (this.spongeResult != null) {
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.func_200442_b(), this.resultFunction));
        }
        if (this.remainingItemsFunction != null) {
            json.addProperty("sponge:remaining_items", IngredientResultUtil.cacheRemainingItemsFunction(this.func_200442_b(), this.remainingItemsFunction));
        }
    }
}

