/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Function;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;

public class SpongeShapelessCraftingRecipeSerializer
extends ShapelessRecipe.Serializer {
    public static IRecipeSerializer<?> SPONGE_CRAFTING_SHAPELESS = SpongeRecipeRegistration.register("crafting_shapeless", new SpongeShapelessCraftingRecipeSerializer());

    public ShapelessRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
        String s2 = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> nonnulllist = this.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe");
        }
        ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        ItemStack spongeStack = IngredientResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        Function<CraftingInventory, ItemStack> resultFunction = IngredientResultUtil.deserializeResultFunction(json);
        Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction = IngredientResultUtil.deserializeRemainingItemsFunction(json);
        return new SpongeShapelessRecipe(recipeId, s2, spongeStack == null ? itemstack : spongeStack, nonnulllist, resultFunction, remainingItemsFunction);
    }

    private NonNullList<Ingredient> readIngredients(JsonArray json) {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        for (JsonElement element : json) {
            Ingredient ingredient = IngredientUtil.spongeDeserialize(element);
            if (ingredient.func_203189_d()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public ShapelessRecipe func_199426_a_(ResourceLocation p_199426_1_, PacketBuffer p_199426_2_) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void func_199427_a_(PacketBuffer p_199427_1_, ShapelessRecipe p_199427_2_) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }
}

