/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;

public class SpongeSmithingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Ingredient base;
    private final Ingredient addition;
    private final Item result;
    private final ItemStack spongeResult;
    private Function<IInventory, ItemStack> resultFunction;

    public SpongeSmithingRecipeRegistration(ResourceLocation key, IRecipeSerializer<?> serializer, String group, Ingredient base, Ingredient addition, ItemStack spongeResult, Function<IInventory, ItemStack> resultFunction) {
        super(key, serializer, spongeResult.func_77973_b(), group);
        this.base = base;
        this.addition = addition;
        this.result = spongeResult.func_77973_b();
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        json.add("base", this.base.func_200304_c());
        json.add("addition", this.addition.func_200304_c());
    }

    @Override
    public void serializeResult(JsonObject json) {
        JsonObject item = new JsonObject();
        item.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result).toString());
        json.add("result", item);
        if (this.spongeResult != null) {
            json.add("sponge:result", IngredientResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", IngredientResultUtil.cacheResultFunction(this.func_200442_b(), this.resultFunction));
        }
    }
}

