/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.SmithingRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipe;

public class SpongeSmithingRecipeSerializer<R extends SmithingRecipe>
implements IRecipeSerializer<R> {
    public static IRecipeSerializer<?> SPONGE_SMITHING = SpongeRecipeRegistration.register("smithing", new SpongeSmithingRecipeSerializer());

    public R fromJson(ResourceLocation recipeId, JsonObject json) {
        Ingredient base = IngredientUtil.spongeDeserialize(json.get("base"));
        Ingredient addition = IngredientUtil.spongeDeserialize(json.get("addition"));
        Function<IInventory, ItemStack> resultFunction = IngredientResultUtil.deserializeResultFunction(json);
        ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        ItemStack spongeStack = IngredientResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        return (R)((Object)new SpongeSmithingRecipe(recipeId, base, addition, spongeStack == null ? itemstack : spongeStack, resultFunction));
    }

    public R fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void toNetwork(PacketBuffer buffer, R recipe) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }
}

