/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.item.util.NativeStackException;

public abstract class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static net.minecraft.item.ItemStack toNative(@Nullable ItemStack stack) {
        if (stack instanceof net.minecraft.item.ItemStack || stack == null) {
            return stack == null ? ItemStackUtil.emptyNative() : (net.minecraft.item.ItemStack)stack;
        }
        throw new NativeStackException("The supplied item stack was not native to the current platform");
    }

    public static net.minecraft.item.ItemStack[] toNative(List<ItemStack> items) {
        return (net.minecraft.item.ItemStack[])items.stream().map(ItemStackUtil::toNative).toArray(net.minecraft.item.ItemStack[]::new);
    }

    public static net.minecraft.item.ItemStack[] fromSnapshotToNative(List<ItemStackSnapshot> items) {
        return (net.minecraft.item.ItemStack[])items.stream().map(ItemStackUtil::fromSnapshotToNative).toArray(net.minecraft.item.ItemStack[]::new);
    }

    public static ItemStack fromNative(net.minecraft.item.ItemStack stack) {
        if (stack instanceof ItemStack) {
            return (ItemStack)stack;
        }
        throw new NativeStackException("The supplied native item stack was not compatible with the target environment");
    }

    public static List<ItemStack> fromNative(net.minecraft.item.ItemStack[] items) {
        return Arrays.stream(items).map(ItemStackUtil::fromNative).collect(Collectors.toList());
    }

    public static net.minecraft.item.ItemStack cloneDefensiveNative(net.minecraft.item.ItemStack stack) {
        return stack.func_77946_l();
    }

    public static net.minecraft.item.ItemStack cloneDefensiveNative(net.minecraft.item.ItemStack stack, int newSize) {
        net.minecraft.item.ItemStack clone = stack.func_77946_l();
        if (!clone.func_190926_b()) {
            clone.func_190920_e(newSize);
        }
        return clone;
    }

    public static ItemStack cloneDefensive(net.minecraft.item.ItemStack stack) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack);
    }

    public static ItemStack cloneDefensive(@Nullable ItemStack stack) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack));
    }

    public static ItemStack cloneDefensive(net.minecraft.item.ItemStack stack, int newSize) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack, newSize);
    }

    public static ItemStack cloneDefensive(@Nullable ItemStack stack, int newSize) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack), newSize);
    }

    public static Optional<ItemStack> cloneDefensiveOptional(net.minecraft.item.ItemStack stack) {
        return Optional.of(ItemStackUtil.cloneDefensive(stack));
    }

    public static Optional<ItemStack> cloneDefensiveOptional(net.minecraft.item.ItemStack stack, int withdraw) {
        return Optional.of(ItemStackUtil.cloneDefensive(stack));
    }

    public static boolean compareIgnoreQuantity(net.minecraft.item.ItemStack stack1, net.minecraft.item.ItemStack stack2) {
        return stack1.func_77969_a(stack2) && net.minecraft.item.ItemStack.func_77970_a((net.minecraft.item.ItemStack)stack1, (net.minecraft.item.ItemStack)stack2);
    }

    public static boolean compareIgnoreQuantity(net.minecraft.item.ItemStack stack1, ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(stack1, ItemStackUtil.toNative(stack2));
    }

    public static boolean compareIgnoreQuantity(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(ItemStackUtil.toNative(stack1), ItemStackUtil.toNative(stack2));
    }

    public static boolean compareIgnoreQuantity(ItemStack stack1, net.minecraft.item.ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(ItemStackUtil.toNative(stack1), stack2);
    }

    public static ItemStackSnapshot snapshotOf(net.minecraft.item.ItemStack itemStack) {
        return itemStack.func_190926_b() ? ItemStackSnapshot.empty() : ItemStackUtil.fromNative(itemStack).createSnapshot();
    }

    public static ItemStackSnapshot snapshotOf(@Nullable ItemStack itemStack) {
        return itemStack == null ? ItemStackSnapshot.empty() : (itemStack.isEmpty() ? ItemStackSnapshot.empty() : itemStack.createSnapshot());
    }

    public static net.minecraft.item.ItemStack fromSnapshotToNative(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? ItemStackUtil.emptyNative() : (snapshot == ItemStackSnapshot.empty() ? ItemStackUtil.emptyNative() : ItemStackUtil.toNative(snapshot.createStack()));
    }

    public static ItemStack fromSnapshot(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? ItemStackUtil.empty() : (snapshot.isEmpty() ? ItemStackUtil.empty() : snapshot.createStack());
    }

    public static ItemStack empty() {
        return ItemStackUtil.fromNative(net.minecraft.item.ItemStack.field_190927_a);
    }

    public static net.minecraft.item.ItemStack emptyNative() {
        return net.minecraft.item.ItemStack.field_190927_a;
    }
}

