/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.canvas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.world.storage.MapData;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.map.MapCanvas;
import org.spongepowered.api.map.color.MapColor;
import org.spongepowered.api.map.color.MapColorTypes;
import org.spongepowered.common.map.canvas.SpongeMapCanvas;
import org.spongepowered.common.util.Constants;

public final class SpongeEmptyCanvas
implements SpongeMapCanvas {
    public static final SpongeEmptyCanvas INSTANCE = new SpongeEmptyCanvas();

    private SpongeEmptyCanvas() {
    }

    @Override
    public MapColor color(int x, int y) {
        return MapColor.of(MapColorTypes.NONE.get());
    }

    @Override
    public Image toImage() {
        return new BufferedImage(128, 128, 1);
    }

    @Override
    public Image toImage(Color color) {
        BufferedImage image = new BufferedImage(128, 128, 1);
        Graphics graphics = image.getGraphics();
        graphics.setColor(color);
        graphics.drawRect(0, 0, image.getWidth(), image.getHeight());
        return image;
    }

    @Override
    public MapCanvas.Builder toBuilder() {
        return MapCanvas.builder();
    }

    @Override
    public int contentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Map.MAP_CANVAS, Collections.singletonList(new byte[16384]));
    }

    @Override
    public void applyToMapData(MapData mapData) {
        Arrays.fill(mapData.field_76198_e, (byte)0);
    }
}

